/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;

public class HCANNHelper {
    private static Method getMemberMethod;

    static {
        Class<JavaXMember> javaXMemberClass = JavaXMember.class;
        try {
            getMemberMethod = javaXMemberClass.getDeclaredMethod("getMember", new Class[0]);
            getMemberMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionFailure("Could not resolve JavaXMember#getMember method in order to access XProperty member signature", e);
        }
        catch (Exception e) {
            throw new HibernateException("Could not access org.hibernate.annotations.common.reflection.java.JavaXMember#getMember method", e);
        }
    }

    public static String annotatedElementSignature(XProperty xProperty) {
        return HCANNHelper.getUnderlyingMember(xProperty).toString();
    }

    public static Member getUnderlyingMember(XProperty xProperty) {
        try {
            return (Member)getMemberMethod.invoke((Object)xProperty, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionFailure("Could not resolve member signature from XProperty reference", e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionFailure("Could not resolve member signature from XProperty reference", e.getCause());
        }
    }
}

