/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class PersistentArrayHolder
extends AbstractPersistentCollection {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PersistentArrayHolder.class.getName());
    protected Object array;
    private transient Class elementClass;
    private transient List tempList;

    public PersistentArrayHolder(SharedSessionContractImplementor session, Object array) {
        super(session);
        this.array = array;
        this.setInitialized();
    }

    @Deprecated
    public PersistentArrayHolder(SessionImplementor session, Object array) {
        this((SharedSessionContractImplementor)session, array);
    }

    public PersistentArrayHolder(SharedSessionContractImplementor session, CollectionPersister persister) {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    @Deprecated
    public PersistentArrayHolder(SessionImplementor session, CollectionPersister persister) {
        this((SharedSessionContractImplementor)session, persister);
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        int i = 0;
        while (i < length) {
            Object elt = Array.get(this.array, i);
            try {
                Array.set(result, i, persister.getElementType().deepCopy(elt, persister.getFactory()));
            }
            catch (IllegalArgumentException iae) {
                LOG.invalidArrayElementType(iae.getMessage());
                throw new HibernateException("Array element type error", iae);
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return Array.getLength(snapshot) == 0;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Object[] sn = (Object[])snapshot;
        Object[] arr = (Object[])this.array;
        ArrayList result = new ArrayList();
        Collections.addAll(result, sn);
        int i = 0;
        while (i < sn.length) {
            PersistentArrayHolder.identityRemove(result, arr[i], entityName, this.getSession());
            ++i;
        }
        return result;
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.array == collection;
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        int i = 0;
        while (i < xlen) {
            if (elementType.isDirty(Array.get(snapshot, i), Array.get(this.array, i), this.getSession())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            list.add(Array.get(this.array, i));
            ++i;
        }
        return list.iterator();
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    public Object readFrom(ResultSet rs, CollectionPersister persister, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, descriptor.getSuffixedElementAliases(), this.getSession());
        int index = (Integer)persister.readIndex(rs, descriptor.getSuffixedIndexAliases(), this.getSession());
        int i = this.tempList.size();
        while (i <= index) {
            this.tempList.add(i, null);
            ++i;
        }
        this.tempList.set(index, element);
        return element;
    }

    @Override
    public Iterator entries(CollectionPersister persister) {
        return this.elements();
    }

    @Override
    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    @Override
    public boolean endRead() {
        this.setInitialized();
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        int i = 0;
        while (i < this.tempList.size()) {
            Array.set(this.array, i, this.tempList.get(i));
            ++i;
        }
        this.tempList = null;
        return true;
    }

    @Override
    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
    }

    @Override
    public boolean isDirectlyAccessible() {
        return true;
    }

    @Override
    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        int i = 0;
        while (i < cached.length) {
            Array.set(this.array, i, persister.getElementType().assemble(cached[i], this.getSession(), owner));
            ++i;
        }
    }

    @Override
    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        int i = 0;
        while (i < length) {
            result[i] = persister.getElementType().disassemble(Array.get(this.array, i), this.getSession(), null);
            ++i;
        }
        return result;
    }

    @Override
    public Object getValue() {
        return this.array;
    }

    @Override
    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        int end;
        int i;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            i = arraySize;
            while (i < snSize) {
                deletes.add(i);
                ++i;
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        i = 0;
        while (i < end) {
            if (Array.get(this.array, i) == null && Array.get(sn, i) != null) {
                deletes.add(i);
            }
            ++i;
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i) != null && (i >= Array.getLength(sn) || Array.get(sn, i) == null);
    }

    @Override
    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i < Array.getLength(sn) && Array.get(sn, i) != null && Array.get(this.array, i) != null && elemType.isDirty(Array.get(this.array, i), Array.get(sn, i), this.getSession());
    }

    @Override
    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        return i;
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i) {
        Serializable sn = this.getSnapshot();
        return Array.get(sn, i);
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }
}

