/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class InExpression
implements Criterion {
    private final String propertyName;
    private final Object[] values;

    protected InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    @Override
    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) {
        CharSequence[] columns = criteriaQuery.findColumns(this.propertyName, criteria);
        Dialect dialect = criteriaQuery.getFactory().getDialect();
        if (dialect.supportsRowValueConstructorSyntaxInInList() || columns.length <= 1) {
            String singleValueParam = String.valueOf(StringHelper.repeat("?, ", columns.length - 1)) + "?";
            if (columns.length > 1) {
                singleValueParam = String.valueOf('(') + singleValueParam + ')';
            }
            String params = this.values.length > 0 ? String.valueOf(StringHelper.repeat(String.valueOf(singleValueParam) + ", ", this.values.length - 1)) + singleValueParam : (dialect.supportsEmptyInList() ? "" : "null");
            String cols = String.join((CharSequence)", ", columns);
            if (columns.length > 1) {
                cols = String.valueOf('(') + cols + ')';
            }
            return String.valueOf(cols) + " in (" + params + ')';
        }
        String cols = " ( " + String.join((CharSequence)" = ? and ", columns) + "= ? ) ";
        cols = this.values.length > 0 ? String.valueOf(StringHelper.repeat(String.valueOf(cols) + "or ", this.values.length - 1)) + cols : "";
        cols = " ( " + cols + " ) ";
        return cols;
    }

    @Override
    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) {
        ArrayList<TypedValue> list = new ArrayList<TypedValue>();
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            Type[] subTypes = compositeType.getSubtypes();
            Object[] objectArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                int i = 0;
                while (i < subTypes.length) {
                    Object subValue = value == null ? null : compositeType.getPropertyValues(value, EntityMode.POJO)[i];
                    list.add(new TypedValue(subTypes[i], subValue));
                    ++i;
                }
                ++n2;
            }
        } else {
            Object[] objectArray = this.values;
            int n = this.values.length;
            int n3 = 0;
            while (n3 < n) {
                Object value = objectArray[n3];
                list.add(criteriaQuery.getTypedValue(criteria, this.propertyName, value));
                ++n3;
            }
        }
        return list.toArray(new TypedValue[list.size()]);
    }

    public String toString() {
        return String.valueOf(this.propertyName) + " in (" + StringHelper.toString(this.values) + ')';
    }
}

