/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.spi.SessionEventListenerManager;

public class SessionEventListenerManagerImpl
implements SessionEventListenerManager,
Serializable {
    private SessionEventListener[] listeners;

    public SessionEventListenerManagerImpl(SessionEventListener ... initialListener) {
        this.listeners = initialListener;
    }

    @Override
    public void addListener(SessionEventListener ... additionalListeners) {
        Objects.requireNonNull(additionalListeners);
        SessionEventListener[] existing = this.listeners;
        if (existing == null) {
            this.listeners = Arrays.copyOf(additionalListeners, additionalListeners.length);
        } else {
            SessionEventListener[] newlist = new SessionEventListener[existing.length + additionalListeners.length];
            System.arraycopy(existing, 0, newlist, 0, existing.length);
            System.arraycopy(additionalListeners, 0, newlist, existing.length, additionalListeners.length);
            this.listeners = newlist;
        }
    }

    @Override
    public void transactionCompletion(boolean successful) {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.transactionCompletion(successful);
            ++n2;
        }
    }

    @Override
    public void jdbcConnectionAcquisitionStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcConnectionAcquisitionStart();
            ++n2;
        }
    }

    @Override
    public void jdbcConnectionAcquisitionEnd() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcConnectionAcquisitionEnd();
            ++n2;
        }
    }

    @Override
    public void jdbcConnectionReleaseStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcConnectionReleaseStart();
            ++n2;
        }
    }

    @Override
    public void jdbcConnectionReleaseEnd() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcConnectionReleaseEnd();
            ++n2;
        }
    }

    @Override
    public void jdbcPrepareStatementStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcPrepareStatementStart();
            ++n2;
        }
    }

    @Override
    public void jdbcPrepareStatementEnd() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcPrepareStatementEnd();
            ++n2;
        }
    }

    @Override
    public void jdbcExecuteStatementStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcExecuteStatementStart();
            ++n2;
        }
    }

    @Override
    public void jdbcExecuteStatementEnd() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcExecuteStatementEnd();
            ++n2;
        }
    }

    @Override
    public void jdbcExecuteBatchStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcExecuteBatchStart();
            ++n2;
        }
    }

    @Override
    public void jdbcExecuteBatchEnd() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.jdbcExecuteBatchEnd();
            ++n2;
        }
    }

    @Override
    public void cachePutStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.cachePutStart();
            ++n2;
        }
    }

    @Override
    public void cachePutEnd() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.cachePutEnd();
            ++n2;
        }
    }

    @Override
    public void cacheGetStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.cacheGetStart();
            ++n2;
        }
    }

    @Override
    public void cacheGetEnd(boolean hit) {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.cacheGetEnd(hit);
            ++n2;
        }
    }

    @Override
    public void flushStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.flushStart();
            ++n2;
        }
    }

    @Override
    public void flushEnd(int numberOfEntities, int numberOfCollections) {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.flushEnd(numberOfEntities, numberOfCollections);
            ++n2;
        }
    }

    @Override
    public void partialFlushStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.partialFlushStart();
            ++n2;
        }
    }

    @Override
    public void partialFlushEnd(int numberOfEntities, int numberOfCollections) {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.partialFlushEnd(numberOfEntities, numberOfCollections);
            ++n2;
        }
    }

    @Override
    public void dirtyCalculationStart() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.dirtyCalculationStart();
            ++n2;
        }
    }

    @Override
    public void dirtyCalculationEnd(boolean dirty) {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.dirtyCalculationEnd(dirty);
            ++n2;
        }
    }

    @Override
    public void end() {
        if (this.listeners == null) {
            return;
        }
        SessionEventListener[] sessionEventListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SessionEventListener listener = sessionEventListenerArray[n2];
            listener.end();
            ++n2;
        }
    }
}

