/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.jboss.logging.Logger;

public class DefaultSchemaNameResolver
implements SchemaNameResolver {
    private static final Logger log = Logger.getLogger(DefaultSchemaNameResolver.class);
    public static final DefaultSchemaNameResolver INSTANCE = new DefaultSchemaNameResolver();

    private DefaultSchemaNameResolver() {
    }

    private SchemaNameResolver determineAppropriateResolverDelegate(Connection connection) {
        try {
            Class<?> jdbcConnectionClass = connection.getClass();
            Method getSchemaMethod = jdbcConnectionClass.getMethod("getSchema", new Class[0]);
            if (getSchemaMethod != null && getSchemaMethod.getReturnType().equals(String.class)) {
                try {
                    connection.getSchema();
                    return new SchemaNameResolverJava17Delegate();
                }
                catch (AbstractMethodError abstractMethodError) {
                    log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
                    return SchemaNameResolverFallbackDelegate.INSTANCE;
                }
            }
            log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
            return SchemaNameResolverFallbackDelegate.INSTANCE;
        }
        catch (Exception ignore) {
            log.debugf("Unable to use Java 1.7 Connection#getSchema : An error occurred trying to resolve the connection default schema resolver: " + ignore.getMessage(), new Object[0]);
            return SchemaNameResolverFallbackDelegate.INSTANCE;
        }
    }

    @Override
    public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
        SchemaNameResolver delegate = this.determineAppropriateResolverDelegate(connection);
        return delegate.resolveSchemaName(connection, dialect);
    }

    public static class SchemaNameResolverFallbackDelegate
    implements SchemaNameResolver {
        public static final SchemaNameResolverFallbackDelegate INSTANCE = new SchemaNameResolverFallbackDelegate();

        /*
         * Loose catch block
         */
        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            String command = dialect.getCurrentSchemaCommand();
            if (command == null) {
                throw new HibernateException("Use of DefaultSchemaNameResolver requires Dialect to provide the proper SQL statement/command but provided Dialect [" + dialect.getClass().getName() + "] did not return anything " + "from Dialect#getCurrentSchemaCommand");
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                String string;
                ResultSet resultSet;
                Statement statement;
                block17: {
                    block16: {
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery(dialect.getCurrentSchemaCommand());
                        string = resultSet.next() ? resultSet.getString(1) : null;
                        if (resultSet == null) break block16;
                        resultSet.close();
                    }
                    if (statement == null) break block17;
                    statement.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (statement != null) {
                                statement.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    public static class SchemaNameResolverJava17Delegate
    implements SchemaNameResolver {
        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            return connection.getSchema();
        }
    }
}

