/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import org.hibernate.QueryException;
import org.hibernate.hql.internal.classic.ParserHelper;
import org.hibernate.internal.util.StringHelper;

public class ParameterParser {
    private ParameterParser() {
    }

    public static void parse(String sqlString, Recognizer recognizer) throws QueryException {
        boolean hasMainOutputParameter = ParameterParser.startsWithEscapeCallTemplate(sqlString);
        boolean foundMainOutputParam = false;
        int stringLength = sqlString.length();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inLineComment = false;
        boolean inDelimitedComment = false;
        int indx = 0;
        while (indx < stringLength) {
            boolean lastCharacter;
            char c = sqlString.charAt(indx);
            boolean bl = lastCharacter = indx == stringLength - 1;
            if (inSingleQuotes) {
                recognizer.other(c);
                if ('\'' == c) {
                    inSingleQuotes = false;
                }
            } else if (inDoubleQuotes) {
                recognizer.other(c);
                if ('\"' == c) {
                    inDoubleQuotes = false;
                }
            } else if (inDelimitedComment) {
                recognizer.other(c);
                if (!lastCharacter && '*' == c && '/' == sqlString.charAt(indx + 1)) {
                    inDelimitedComment = false;
                    recognizer.other(sqlString.charAt(indx + 1));
                    ++indx;
                }
            } else if (inLineComment) {
                recognizer.other(c);
                if ('\n' == c) {
                    inLineComment = false;
                } else if ('\r' == c) {
                    inLineComment = false;
                    if (!lastCharacter && '\n' == sqlString.charAt(indx + 1)) {
                        recognizer.other(sqlString.charAt(indx + 1));
                        ++indx;
                    }
                }
            } else if (!lastCharacter && '/' == c && '*' == sqlString.charAt(indx + 1)) {
                inDelimitedComment = true;
                recognizer.other(c);
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
            } else if ('-' == c) {
                recognizer.other(c);
                if (!lastCharacter && '-' == sqlString.charAt(indx + 1)) {
                    inLineComment = true;
                    recognizer.other(sqlString.charAt(indx + 1));
                    ++indx;
                }
            } else if ('\"' == c) {
                inDoubleQuotes = true;
                recognizer.other(c);
            } else if ('\'' == c) {
                inSingleQuotes = true;
                recognizer.other(c);
            } else if ('\\' == c) {
                recognizer.other(sqlString.charAt(++indx));
            } else if (c == ':' && indx < stringLength - 1 && sqlString.charAt(indx + 1) == ':') {
                recognizer.other(c);
                ++indx;
            } else if (c == ':') {
                right = StringHelper.firstIndexOfChar(sqlString, ParserHelper.HQL_SEPARATORS_BITSET, indx + 1);
                chopLocation = right < 0 ? sqlString.length() : right;
                param = sqlString.substring(indx + 1, chopLocation);
                if (param.isEmpty()) {
                    throw new QueryException("Space is not allowed after parameter prefix ':' [" + sqlString + "]");
                }
                recognizer.namedParameter(param, indx);
                indx = chopLocation - 1;
            } else if (c == '?') {
                if (indx < stringLength - 1 && Character.isDigit(sqlString.charAt(indx + 1))) {
                    right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", indx + 1);
                    chopLocation = right < 0 ? sqlString.length() : right;
                    param = sqlString.substring(indx + 1, chopLocation);
                    try {
                        recognizer.jpaPositionalParameter(Integer.parseInt(param), indx);
                        indx = chopLocation - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new QueryException("JPA-style positional param was not an integral ordinal");
                    }
                } else if (hasMainOutputParameter && !foundMainOutputParam) {
                    foundMainOutputParam = true;
                    recognizer.outParameter(indx);
                } else {
                    recognizer.ordinalParameter(indx);
                }
            } else {
                recognizer.other(c);
            }
            ++indx;
        }
        recognizer.complete();
    }

    public static boolean startsWithEscapeCallTemplate(String sqlString) {
        if (!sqlString.startsWith("{") || !sqlString.endsWith("}")) {
            return false;
        }
        int chopLocation = sqlString.indexOf("call");
        if (chopLocation <= 0) {
            return false;
        }
        String checkString = sqlString.substring(1, chopLocation + 4);
        int fixturePosition = 0;
        boolean matches = true;
        int max = checkString.length();
        int i = 0;
        while (i < max) {
            char c = Character.toLowerCase(checkString.charAt(i));
            if (!Character.isWhitespace(c)) {
                if (c == "?=call".charAt(fixturePosition)) {
                    ++fixturePosition;
                } else {
                    matches = false;
                    break;
                }
            }
            ++i;
        }
        return matches;
    }

    public static interface Recognizer {
        public void outParameter(int var1);

        public void ordinalParameter(int var1);

        public void namedParameter(String var1, int var2);

        public void jpaPositionalParameter(int var1, int var2);

        public void other(char var1);

        public void complete();
    }
}

