/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.transaction.jta.platform.internal.AtomikosJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.BitronixJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JOTMJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JOnASJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereLibertyJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WildFlyStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformProvider;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformResolver;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class StandardJtaPlatformResolver
implements JtaPlatformResolver {
    public static final StandardJtaPlatformResolver INSTANCE = new StandardJtaPlatformResolver();
    private static final Logger log = Logger.getLogger(StandardJtaPlatformResolver.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public JtaPlatform resolveJtaPlatform(Map configurationValues, ServiceRegistryImplementor registry) {
        classLoaderService = registry.getService(ClassLoaderService.class);
        for (JtaPlatformProvider provider : classLoaderService.loadJavaServices(JtaPlatformProvider.class)) {
            providedPlatform = provider.getProvidedJtaPlatform();
            StandardJtaPlatformResolver.log.tracef("Located JtaPlatformProvider [%s] provided JtaPlaform : %s", (Object)provider, (Object)providedPlatform);
            if (providedPlatform == null) continue;
            return providedPlatform;
        }
        try {
            classLoaderService.classForName("org.wildfly.transaction.client.ContextTransactionManager");
            classLoaderService.classForName("org.wildfly.transaction.client.LocalUserTransaction");
            return new WildFlyStandAloneJtaPlatform();
        }
        catch (ClassLoadingException v0) {
            try {
                classLoaderService.classForName("com.arjuna.ats.jta.TransactionManager");
                classLoaderService.classForName("com.arjuna.ats.jta.UserTransaction");
                return new JBossStandAloneJtaPlatform();
            }
            catch (ClassLoadingException v1) {
                try {
                    classLoaderService.classForName("com.atomikos.icatch.jta.UserTransactionManager");
                    return new AtomikosJtaPlatform();
                }
                catch (ClassLoadingException v2) {
                    try {
                        classLoaderService.classForName("bitronix.tm.TransactionManagerServices");
                        return new BitronixJtaPlatform();
                    }
                    catch (ClassLoadingException v3) {
                        try {
                            classLoaderService.classForName("org.objectweb.jonas_tm.Current");
                            return new JOnASJtaPlatform();
                        }
                        catch (ClassLoadingException v4) {
                            try {
                                classLoaderService.classForName("org.objectweb.jotm.Current");
                                return new JOTMJtaPlatform();
                            }
                            catch (ClassLoadingException v5) {
                                try {
                                    classLoaderService.classForName("com.ibm.tx.jta.TransactionManagerFactory");
                                    return new WebSphereLibertyJtaPlatform();
                                }
                                catch (ClassLoadingException v6) {
                                    var7_9 = WebSphereJtaPlatform.WebSphereEnvironment.values();
                                    var6_8 = var7_9.length;
                                    var5_5 = 0;
                                    ** while (var5_5 < var6_8)
                                }
                            }
                        }
                    }
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            webSphereEnvironment = var7_9[var5_5];
            try {
                accessClass = classLoaderService.classForName(webSphereEnvironment.getTmAccessClassName());
                return new WebSphereJtaPlatform(accessClass, webSphereEnvironment);
            }
            catch (ClassLoadingException v7) {
                ++var5_5;
            }
            continue;
        }
lbl57:
        // 1 sources

        StandardJtaPlatformResolver.log.debugf("Could not resolve JtaPlatform, using default [%s]", (Object)NoJtaPlatform.class.getName());
        return NoJtaPlatform.INSTANCE;
    }
}

