/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public final class NameGenerator {
    private NameGenerator() {
    }

    public static String[][] generateColumnNames(Type[] types, SessionFactoryImplementor f) throws MappingException {
        String[][] columnNames = new String[types.length][];
        int i = 0;
        while (i < types.length) {
            int span = types[i].getColumnSpan(f);
            columnNames[i] = new String[span];
            int j = 0;
            while (j < span) {
                columnNames[i][j] = NameGenerator.scalarName(i, j);
                ++j;
            }
            ++i;
        }
        return columnNames;
    }

    public static String scalarName(int x, int y) {
        return NameGenerator.scalarName("col_" + x, y);
    }

    public static String scalarName(String base, int num) {
        return String.valueOf(base) + '_' + num + '_';
    }

    public static String[] scalarNames(String base, int count) {
        String[] names = new String[count];
        int j = 0;
        while (j < count) {
            names[j] = NameGenerator.scalarName(base, j);
            ++j;
        }
        return names;
    }

    public static String[] scalarNames(int uniqueness, int count) {
        return NameGenerator.scalarNames("col_" + uniqueness, count);
    }
}

