/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.SqlGenerator;
import org.hibernate.hql.internal.ast.exec.BasicExecutor;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class DeleteExecutor
extends BasicExecutor {
    private static final Logger LOG = Logger.getLogger(DeleteExecutor.class);
    private final List<String> deletes = new ArrayList<String>();
    private List<ParameterSpecification> parameterSpecifications;

    public DeleteExecutor(HqlSqlWalker walker, Queryable persister) {
        super(walker, persister);
        SessionFactoryImplementor factory = walker.getSessionFactoryHelper().getFactory();
        Dialect dialect = factory.getJdbcServices().getJdbcEnvironment().getDialect();
        try {
            String idSubselectWhere;
            DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
            if (deleteStatement.hasWhereClause()) {
                AST whereClause = deleteStatement.getWhereClause();
                SqlGenerator gen = new SqlGenerator(factory);
                gen.whereClause(whereClause);
                this.parameterSpecifications = gen.getCollectedParameters();
                String sql = gen.getSQL();
                idSubselectWhere = sql.length() > 7 ? sql : "";
            } else {
                this.parameterSpecifications = new ArrayList<ParameterSpecification>();
                idSubselectWhere = "";
            }
            boolean commentsEnabled = factory.getSessionFactoryOptions().isCommentsEnabled();
            MetamodelImplementor metamodel = factory.getMetamodel();
            boolean notSupportingTuplesInSubqueries = !dialect.supportsTuplesInSubqueries();
            Type[] typeArray = persister.getPropertyTypes();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollectionType cType;
                AbstractCollectionPersister cPersister;
                Type type = typeArray[n2];
                if (type.isCollectionType() && (cPersister = (AbstractCollectionPersister)metamodel.collectionPersister((cType = (CollectionType)type).getRole())).isManyToMany()) {
                    String[] columnNames;
                    Type keyType = cPersister.getKeyType();
                    if (keyType.isComponentType()) {
                        ComponentType componentType = (ComponentType)keyType;
                        ArrayList columns = new ArrayList(componentType.getPropertyNames().length);
                        try {
                            String[] stringArray = componentType.getPropertyNames();
                            int n3 = stringArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String propertyName = stringArray[n4];
                                Collections.addAll(columns, persister.toColumns(propertyName));
                                ++n4;
                            }
                            columnNames = columns.toArray(new String[0]);
                        }
                        catch (MappingException mappingException) {
                            columnNames = persister.getIdentifierColumnNames();
                        }
                    } else {
                        columnNames = persister.getIdentifierColumnNames();
                    }
                    if (columnNames.length > 1 && notSupportingTuplesInSubqueries) {
                        LOG.warn((Object)"This dialect is unable to cascade the delete into the many-to-many join table when the entity has multiple primary keys.  Either properly setup cascading on the constraints or manually clear the associations prior to deleting the entities.");
                    } else {
                        StringBuilder whereBuilder = new StringBuilder();
                        whereBuilder.append('(');
                        DeleteExecutor.append(", ", cPersister.getKeyColumnNames(), whereBuilder);
                        whereBuilder.append(") in (select ");
                        DeleteExecutor.append(", ", columnNames, whereBuilder);
                        String where = whereBuilder.append(" from ").append(persister.getTableName()).append(idSubselectWhere).append(")").toString();
                        Delete delete = new Delete().setTableName(cPersister.getTableName()).setWhere(where);
                        if (commentsEnabled) {
                            delete.setComment("delete FKs in join table");
                        }
                        this.deletes.add(delete.toStatementString());
                    }
                }
                ++n2;
            }
        }
        catch (RecognitionException e) {
            throw new HibernateException("Unable to delete the FKs in the join table!", e);
        }
    }

    private static void append(String delimiter, String[] parts, StringBuilder sb) {
        sb.append(parts[0]);
        int i = 1;
        while (i < parts.length) {
            sb.append(delimiter);
            sb.append(parts[i]);
            ++i;
        }
    }

    @Override
    public int execute(QueryParameters parameters, SharedSessionContractImplementor session) throws HibernateException {
        for (String delete : this.deletes) {
            this.doExecute(parameters, session, delete, this.parameterSpecifications);
        }
        return super.execute(parameters, session);
    }
}

