/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.QueryException;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.SelectExpression;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.util.ASTUtil;
import org.hibernate.hql.internal.ast.util.ColumnHelper;
import org.hibernate.type.Type;

public class SimpleCaseNode
extends AbstractSelectExpression
implements SelectExpression,
ExpectedTypeAwareNode {
    @Override
    public Type getDataType() {
        AST expression = this.getFirstChild();
        AST option = expression.getNextSibling();
        while (option != null) {
            Type nodeDataType;
            AST result;
            if (option.getType() == 60) {
                result = option.getFirstChild().getNextSibling();
            } else if (option.getType() == 58) {
                result = option.getFirstChild();
            } else {
                throw new QueryException("Unexpected node type :" + ASTUtil.getTokenTypeName(HqlSqlTokenTypes.class, option.getType()) + "; expecting WHEN or ELSE");
            }
            if (SqlNode.class.isInstance(result) && (nodeDataType = ((SqlNode)result).getDataType()) != null) {
                return nodeDataType;
            }
            option = option.getNextSibling();
        }
        return null;
    }

    @Override
    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }

    @Override
    public void setExpectedType(Type expectedType) {
        AST option = this.getFirstChild();
        while (option != null) {
            if (option.getType() == 60) {
                if (ParameterNode.class.isAssignableFrom(option.getFirstChild().getNextSibling().getClass())) {
                    ((ParameterNode)option.getFirstChild().getNextSibling()).setExpectedType(expectedType);
                }
            } else if (option.getType() == 58 && ParameterNode.class.isAssignableFrom(option.getFirstChild().getClass())) {
                ((ParameterNode)option.getFirstChild()).setExpectedType(expectedType);
            }
            option = option.getNextSibling();
        }
    }

    @Override
    public Type getExpectedType() {
        return null;
    }
}

