/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi.id.cte;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.cte.AbstractCteValuesListBulkIdHandler;
import org.hibernate.hql.spi.id.cte.CteValuesListBuilder;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.sql.Delete;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class CteValuesListDeleteHandlerImpl
extends AbstractCteValuesListBulkIdHandler
implements MultiTableBulkIdStrategy.DeleteHandler {
    private final List<String> deletes = new ArrayList<String>();

    public CteValuesListDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        this(factory, walker, null, null);
    }

    public CteValuesListDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, String catalog, String schema) {
        super(factory, walker, catalog, schema);
        String idSubselect = this.generateIdSubselect(this.getTargetedQueryable());
        Type[] typeArray = this.getTargetedQueryable().getPropertyTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type.isCollectionType()) {
                CollectionType cType = (CollectionType)type;
                AbstractCollectionPersister cPersister = (AbstractCollectionPersister)factory.getMetamodel().collectionPersister(cType.getRole());
                if (cPersister.isManyToMany()) {
                    this.deletes.add(this.generateDelete(cPersister.getTableName(), cPersister.getKeyColumnNames(), this.generateIdSubselect(idSubselect, this.getTargetedQueryable(), cPersister), "bulk delete - m2m join table cleanup"));
                }
            }
            ++n2;
        }
        String[] tableNames = this.getTargetedQueryable().getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.getTargetedQueryable().getContraintOrderedTableKeyColumnClosure();
        int i = 0;
        while (i < tableNames.length) {
            this.deletes.add(this.generateDelete(tableNames[i], columnNames[i], idSubselect, "bulk delete"));
            ++i;
        }
    }

    @Override
    public int execute(SharedSessionContractImplementor session, QueryParameters queryParameters) {
        CteValuesListBuilder values = this.prepareCteStatement(session, queryParameters);
        if (!values.getIds().isEmpty()) {
            for (String deleteSuffix : this.deletes) {
                if (deleteSuffix == null) continue;
                String delete = values.toStatement(deleteSuffix);
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (PreparedStatement ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(delete, false);){
                        int pos = 1;
                        Iterator<Object[]> iterator = values.getIds().iterator();
                        while (iterator.hasNext()) {
                            Object[] result;
                            Object[] objectArray = result = iterator.next();
                            int n = result.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object column = objectArray[n2];
                                ps.setObject(pos++, column);
                                ++n2;
                            }
                        }
                        session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw this.convert(e, "error performing bulk delete", delete);
                }
            }
        }
        return values.getIds().size();
    }

    private String generateDelete(String tableName, String[] columnNames, String idSubselect, String comment) {
        Delete delete = new Delete().setTableName(tableName).setWhere("(" + String.join((CharSequence)", ", columnNames) + ") in (" + idSubselect + ")");
        if (this.factory().getSessionFactoryOptions().isCommentsEnabled()) {
            delete.setComment(comment);
        }
        return delete.toStatementString();
    }

    @Override
    public String[] getSqlStatements() {
        return this.deletes.toArray(new String[this.deletes.size()]);
    }
}

