/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi.id.cte;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AssignmentSpecification;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.cte.AbstractCteValuesListBulkIdHandler;
import org.hibernate.hql.spi.id.cte.CteValuesListBuilder;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.sql.Update;

public class CteValuesListUpdateHandlerImpl
extends AbstractCteValuesListBulkIdHandler
implements MultiTableBulkIdStrategy.UpdateHandler {
    private final String[] updates;
    private final ParameterSpecification[][] assignmentParameterSpecifications;

    public CteValuesListUpdateHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        this(factory, walker, null, null);
    }

    public CteValuesListUpdateHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, String catalog, String schema) {
        super(factory, walker, catalog, schema);
        String[] tableNames = this.getTargetedQueryable().getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.getTargetedQueryable().getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.getTargetedQueryable());
        this.updates = new String[tableNames.length];
        this.assignmentParameterSpecifications = new ParameterSpecification[tableNames.length][];
        int tableIndex = 0;
        while (tableIndex < tableNames.length) {
            boolean affected = false;
            ArrayList parameterList = new ArrayList();
            Update update = new Update(factory.getServiceRegistry().getService(JdbcServices.class).getDialect()).setTableName(tableNames[tableIndex]).setWhere("(" + String.join((CharSequence)", ", columnNames[tableIndex]) + ") in (" + idSubselect + ")");
            if (this.factory().getSessionFactoryOptions().isCommentsEnabled()) {
                update.setComment("bulk update");
            }
            ArrayList assignmentSpecifications = walker.getAssignmentSpecifications();
            for (AssignmentSpecification assignmentSpecification : assignmentSpecifications) {
                if (!assignmentSpecification.affectsTable(tableNames[tableIndex])) continue;
                affected = true;
                update.appendAssignmentFragment(assignmentSpecification.getSqlAssignmentFragment());
                if (assignmentSpecification.getParameters() == null) continue;
                Collections.addAll(parameterList, assignmentSpecification.getParameters());
            }
            if (affected) {
                this.updates[tableIndex] = update.toStatementString();
                this.assignmentParameterSpecifications[tableIndex] = parameterList.toArray(new ParameterSpecification[parameterList.size()]);
            }
            ++tableIndex;
        }
    }

    @Override
    public String[] getSqlStatements() {
        return this.updates;
    }

    @Override
    public int execute(SharedSessionContractImplementor session, QueryParameters queryParameters) {
        CteValuesListBuilder values = this.prepareCteStatement(session, queryParameters);
        if (!values.getIds().isEmpty()) {
            int i = 0;
            while (i < this.updates.length) {
                String updateSuffix = this.updates[i];
                if (updateSuffix != null) {
                    String update = values.toStatement(updateSuffix);
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (PreparedStatement ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(update, false);){
                            int position = 1;
                            Iterator<Object[]> iterator = values.getIds().iterator();
                            while (iterator.hasNext()) {
                                Object[] result;
                                Object[] objectArray = result = iterator.next();
                                int n = result.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object column = objectArray[n2];
                                    ps.setObject(position++, column);
                                    ++n2;
                                }
                            }
                            if (this.assignmentParameterSpecifications[i] != null) {
                                ParameterSpecification[] parameterSpecificationArray = this.assignmentParameterSpecifications[i];
                                int n = parameterSpecificationArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    ParameterSpecification assignmentParameterSpecification = parameterSpecificationArray[n3];
                                    position += assignmentParameterSpecification.bind(ps, queryParameters, session, position);
                                    ++n3;
                                }
                            }
                            session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        throw this.convert(e, "error performing bulk update", update);
                    }
                }
                ++i;
            }
        }
        return values.getIds().size();
    }
}

