/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi.id.inline;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.hql.spi.id.inline.IdsClauseBuilder;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;

public class InlineIdsOrClauseBuilder
extends IdsClauseBuilder {
    public InlineIdsOrClauseBuilder(Dialect dialect, Type identifierType, TypeResolver typeResolver, String[] columns, List<Object[]> ids) {
        super(dialect, identifierType, typeResolver, columns, ids);
    }

    @Override
    public String toStatement() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.getIds().size()) {
            Object[] idTokens = this.getIds().get(i);
            if (i > 0) {
                buffer.append(" or ");
            }
            buffer.append("(");
            int j = 0;
            while (j < this.getColumns().length) {
                if (j > 0) {
                    buffer.append(" and ");
                }
                buffer.append(this.getColumns()[j]);
                buffer.append(" = ");
                buffer.append(this.quoteIdentifier(idTokens[j]));
                ++j;
            }
            buffer.append(")");
            ++i;
        }
        return buffer.toString();
    }
}

