/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AbstractOptimizer;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.PooledLoOptimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class PooledLoThreadLocalOptimizer
extends AbstractOptimizer {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PooledLoOptimizer.class.getName());
    private Map<String, GenerationState> tenantSpecificState;
    private final ThreadLocal<GenerationState> localAssignedIds = ThreadLocal.withInitial(() -> new GenerationState());

    public PooledLoThreadLocalOptimizer(Class returnClass, int incrementSize) {
        super(returnClass, incrementSize);
        if (incrementSize < 1) {
            throw new HibernateException("increment size cannot be less than 1");
        }
        LOG.creatingPooledLoOptimizer(incrementSize, returnClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable generate(AccessCallback callback) {
        if (callback.getTenantIdentifier() == null) {
            GenerationState local = this.localAssignedIds.get();
            if (local.value != null && local.value.lt(local.upperLimitValue)) {
                return local.value.makeValueThenIncrement();
            }
        }
        PooledLoThreadLocalOptimizer pooledLoThreadLocalOptimizer = this;
        synchronized (pooledLoThreadLocalOptimizer) {
            GenerationState generationState = this.locateGenerationState(callback.getTenantIdentifier());
            if (generationState.lastSourceValue == null || !generationState.value.lt(generationState.upperLimitValue)) {
                generationState.lastSourceValue = callback.getNextValue();
                generationState.upperLimitValue = generationState.lastSourceValue.copy().add(this.incrementSize);
                generationState.value = generationState.lastSourceValue.copy();
                while (generationState.value.lt(1L)) {
                    generationState.value.increment();
                }
            }
            return generationState.value.makeValueThenIncrement();
        }
    }

    private GenerationState locateGenerationState(String tenantIdentifier) {
        GenerationState state;
        if (tenantIdentifier == null) {
            return this.localAssignedIds.get();
        }
        if (this.tenantSpecificState == null) {
            this.tenantSpecificState = new HashMap<String, GenerationState>();
            state = new GenerationState();
            this.tenantSpecificState.put(tenantIdentifier, state);
        } else {
            state = this.tenantSpecificState.get(tenantIdentifier);
            if (state == null) {
                state = new GenerationState();
                this.tenantSpecificState.put(tenantIdentifier, state);
            }
        }
        return state;
    }

    private GenerationState noTenantGenerationState() {
        GenerationState noTenantState = this.locateGenerationState(null);
        if (noTenantState == null) {
            throw new IllegalStateException("Could not locate previous generation state for no-tenant");
        }
        return noTenantState;
    }

    @Override
    public IntegralDataTypeHolder getLastSourceValue() {
        return this.noTenantGenerationState().lastSourceValue;
    }

    @Override
    public boolean applyIncrementSizeToSourceValues() {
        return true;
    }

    private static class GenerationState {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;
        private IntegralDataTypeHolder upperLimitValue;

        private GenerationState() {
        }
    }
}

