/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SequenceStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SequenceStructure.class.getName());
    private final QualifiedName logicalQualifiedSequenceName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private String sql;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;
    protected String sequenceName;

    public SequenceStructure(JdbcEnvironment jdbcEnvironment, QualifiedName qualifiedSequenceName, int initialValue, int incrementSize, Class numberType) {
        this.logicalQualifiedSequenceName = qualifiedSequenceName;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.numberType = numberType;
    }

    @Override
    public String getName() {
        return this.sequenceName;
    }

    @Override
    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public int getTimesAccessed() {
        return this.accessCounter;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public AccessCallback buildCallback(final SharedSessionContractImplementor session) {
        if (this.sql == null) {
            throw new AssertionFailure("SequenceStyleGenerator's SequenceStructure was not properly initialized");
        }
        return new AccessCallback(){

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public IntegralDataTypeHolder getNextValue() {
                ++SequenceStructure.this.accessCounter;
                try {
                    PreparedStatement st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(SequenceStructure.this.sql);
                    try {
                        IntegralDataTypeHolder integralDataTypeHolder;
                        ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(st);
                        try {
                            rs.next();
                            IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder(SequenceStructure.this.numberType);
                            value.initialize(rs, 1L);
                            if (LOG.isDebugEnabled()) {
                                LOG.debugf("Sequence value obtained: %s", value.makeValue());
                            }
                            integralDataTypeHolder = value;
                        }
                        catch (Throwable throwable) {
                            try {
                                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                            }
                            catch (Throwable throwable2) {}
                            throw throwable;
                        }
                        try {
                            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                        }
                        catch (Throwable throwable) {}
                        return integralDataTypeHolder;
                    }
                    finally {
                        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                        session.getJdbcCoordinator().afterStatementExecution();
                    }
                }
                catch (SQLException sqle) {
                    throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not get next sequence value", SequenceStructure.this.sql);
                }
            }

            @Override
            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        };
    }

    @Override
    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    @Override
    public void registerExportables(Database database) {
        this.buildSequence(database);
        this.sql = database.getJdbcEnvironment().getDialect().getSequenceNextValString(this.sequenceName);
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return dialect.getCreateSequenceStrings(this.sequenceName, this.initialValue, this.getSourceIncrementSize());
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    @Override
    public boolean isPhysicalSequence() {
        return true;
    }

    protected final int getSourceIncrementSize() {
        return this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
    }

    protected QualifiedName getQualifiedName() {
        return this.logicalQualifiedSequenceName;
    }

    protected void buildSequence(Database database) {
        int sourceIncrementSize = this.getSourceIncrementSize();
        Namespace namespace = database.locateNamespace(this.logicalQualifiedSequenceName.getCatalogName(), this.logicalQualifiedSequenceName.getSchemaName());
        Sequence sequence = namespace.locateSequence(this.logicalQualifiedSequenceName.getObjectName());
        if (sequence != null) {
            sequence.validate(this.initialValue, sourceIncrementSize);
        } else {
            sequence = namespace.createSequence(this.logicalQualifiedSequenceName.getObjectName(), this.initialValue, sourceIncrementSize);
        }
        this.sequenceName = database.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(sequence.getName(), database.getJdbcEnvironment().getDialect());
    }
}

