/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.HibernateException;

public class Cloneable {
    private static final Object[] READER_METHOD_ARGS = new Object[0];

    public Object shallowCopy() {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Cloneable.this.copyListeners();
            }
        });
    }

    public void validate() throws HibernateException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cloneable.this.checkListeners();
                return null;
            }
        });
    }

    private Object copyListeners() {
        Object copy = null;
        BeanInfo beanInfo = null;
        try {
            try {
                PropertyDescriptor[] pds;
                beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
                this.internalCheckListeners(beanInfo);
                copy = this.getClass().newInstance();
                PropertyDescriptor[] propertyDescriptorArray = pds = beanInfo.getPropertyDescriptors();
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    try {
                        pd.getWriteMethod().invoke(copy, pd.getReadMethod().invoke((Object)this, READER_METHOD_ARGS));
                    }
                    catch (Throwable throwable) {
                        throw new HibernateException("Unable copy copy listener [" + pd.getName() + "]");
                    }
                    ++n2;
                }
            }
            catch (Exception t) {
                throw new HibernateException("Unable to copy listeners", t);
            }
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(this.getClass());
            }
        }
        return copy;
    }

    private void checkListeners() {
        BeanInfo beanInfo = null;
        try {
            try {
                beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
                this.internalCheckListeners(beanInfo);
            }
            catch (IntrospectionException t) {
                throw new HibernateException("Unable to validate listener config", t);
            }
        }
        finally {
            if (beanInfo != null) {
                Introspector.flushFromCaches(this.getClass());
            }
        }
    }

    private void internalCheckListeners(BeanInfo beanInfo) {
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        try {
            PropertyDescriptor[] propertyDescriptorArray = pds;
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                Object listener = pd.getReadMethod().invoke((Object)this, READER_METHOD_ARGS);
                if (listener == null) {
                    throw new HibernateException("Listener [" + pd.getName() + "] was null");
                }
                if (listener.getClass().isArray()) {
                    Object[] listenerArray;
                    Object[] objectArray = listenerArray = (Object[])listener;
                    int n3 = listenerArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object aListenerArray = objectArray[n4];
                        if (aListenerArray == null) {
                            throw new HibernateException("Listener in [" + pd.getName() + "] was null");
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Unable to validate listener config");
        }
    }
}

