/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.sql.SQLException;

public final class JdbcExceptionHelper {
    private JdbcExceptionHelper() {
    }

    public static int extractErrorCode(SQLException sqlException) {
        int errorCode = sqlException.getErrorCode();
        SQLException nested = sqlException.getNextException();
        while (errorCode == 0 && nested != null) {
            errorCode = nested.getErrorCode();
            nested = nested.getNextException();
        }
        return errorCode;
    }

    public static String extractSqlState(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        SQLException nested = sqlException.getNextException();
        while (sqlState == null && nested != null) {
            sqlState = nested.getSQLState();
            nested = nested.getNextException();
        }
        return sqlState;
    }

    public static String extractSqlStateClassCode(SQLException sqlException) {
        return JdbcExceptionHelper.determineSqlStateClassCode(JdbcExceptionHelper.extractSqlState(sqlException));
    }

    public static String determineSqlStateClassCode(String sqlState) {
        if (sqlState == null || sqlState.length() < 2) {
            return sqlState;
        }
        return sqlState.substring(0, 2);
    }
}

