/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.type.PrimitiveWrapperHelper;
import org.hibernate.loader.custom.JdbcResultMetadata;
import org.hibernate.loader.custom.ResultColumnProcessor;
import org.hibernate.loader.custom.ScalarResultColumnProcessor;
import org.hibernate.type.Type;

public class ConstructorResultColumnProcessor
implements ResultColumnProcessor {
    private final Class targetClass;
    private final ScalarResultColumnProcessor[] scalarProcessors;
    private Constructor constructor;

    public ConstructorResultColumnProcessor(Class targetClass, ScalarResultColumnProcessor[] scalarProcessors) {
        this.targetClass = targetClass;
        this.scalarProcessors = scalarProcessors;
    }

    @Override
    public void performDiscovery(JdbcResultMetadata metadata, List<Type> types, List<String> aliases) throws SQLException {
        ArrayList<Type> localTypes = new ArrayList<Type>();
        ScalarResultColumnProcessor[] scalarResultColumnProcessorArray = this.scalarProcessors;
        int n = this.scalarProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            ScalarResultColumnProcessor scalar = scalarResultColumnProcessorArray[n2];
            scalar.performDiscovery(metadata, localTypes, aliases);
            ++n2;
        }
        types.addAll(localTypes);
        this.constructor = ConstructorResultColumnProcessor.resolveConstructor(this.targetClass, localTypes);
    }

    @Override
    public Object extract(Object[] data, ResultSet resultSet, SharedSessionContractImplementor session) throws SQLException, HibernateException {
        if (this.constructor == null) {
            throw new IllegalStateException("Constructor to call was null");
        }
        Object[] args = new Object[this.scalarProcessors.length];
        int i = 0;
        while (i < this.scalarProcessors.length) {
            args[i] = this.scalarProcessors[i].extract(data, resultSet, session);
            ++i;
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new HibernateException(String.format("Unable to call %s constructor", this.constructor.getDeclaringClass()), e);
        }
    }

    private static Constructor resolveConstructor(Class targetClass, List<Type> types) {
        Constructor<?>[] constructorArray = targetClass.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] argumentTypes = constructor.getParameterTypes();
            if (argumentTypes.length == types.size()) {
                boolean allMatched = true;
                int i = 0;
                while (i < argumentTypes.length) {
                    if (!ConstructorResultColumnProcessor.areAssignmentCompatible(argumentTypes[i], types.get(i).getReturnedClass())) {
                        allMatched = false;
                        break;
                    }
                    ++i;
                }
                if (allMatched) {
                    return constructor;
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("Could not locate appropriate constructor on class : " + targetClass.getName());
    }

    private static boolean areAssignmentCompatible(Class argumentType, Class typeReturnedClass) {
        return argumentType.isAssignableFrom(typeReturnedClass) || PrimitiveWrapperHelper.arePrimitiveWrapperEquivalents(argumentType, typeReturnedClass);
    }
}

