/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyConfiguration;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyInterceptor;
import org.hibernate.proxy.pojo.bytebuddy.SerializableProxy;

public class ByteBuddyProxyHelper
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ByteBuddyProxyHelper.class);
    private static final String PROXY_NAMING_SUFFIX = Environment.useLegacyProxyClassnames() ? "HibernateProxy$" : "HibernateProxy";
    private final ByteBuddyState byteBuddyState;

    public ByteBuddyProxyHelper(ByteBuddyState byteBuddyState) {
        this.byteBuddyState = byteBuddyState;
    }

    public Class buildProxy(Class persistentClass, Class[] interfaces) {
        HashSet<Class> key = new HashSet<Class>();
        if (interfaces.length == 1) {
            key.add(persistentClass);
        }
        key.addAll(Arrays.asList(interfaces));
        return this.byteBuddyState.loadProxy(persistentClass, new TypeCache.SimpleKey(key), this.proxyBuilder(persistentClass, interfaces));
    }

    public DynamicType.Unloaded<?> buildUnloadedProxy(Class persistentClass, Class[] interfaces) {
        return this.byteBuddyState.make(this.proxyBuilder(persistentClass, interfaces));
    }

    private Function<ByteBuddy, DynamicType.Builder<?>> proxyBuilder(Class persistentClass, Class[] interfaces) {
        return byteBuddy -> byteBuddy.ignore(this.byteBuddyState.getProxyDefinitionHelpers().getGroovyGetMetaClassFilter()).with((NamingStrategy)new NamingStrategy.SuffixingRandom(PROXY_NAMING_SUFFIX, (NamingStrategy.SuffixingRandom.BaseNameResolver)new NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue(persistentClass.getName()))).subclass(interfaces.length == 1 ? persistentClass : Object.class, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS_OPENING).implement((Type[])interfaces).method(this.byteBuddyState.getProxyDefinitionHelpers().getVirtualNotFinalizerFilter()).intercept((Implementation)this.byteBuddyState.getProxyDefinitionHelpers().getDelegateToInterceptorDispatcherMethodDelegation()).method(this.byteBuddyState.getProxyDefinitionHelpers().getHibernateGeneratedMethodFilter()).intercept((Implementation)SuperMethodCall.INSTANCE).defineField("$$_hibernate_interceptor", ProxyConfiguration.Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)this.byteBuddyState.getProxyDefinitionHelpers().getInterceptorFieldAccessor());
    }

    public HibernateProxy deserializeProxy(SerializableProxy serializableProxy) {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(serializableProxy.getEntityName(), serializableProxy.getPersistentClass(), serializableProxy.getInterfaces(), serializableProxy.getId(), ByteBuddyProxyHelper.resolveIdGetterMethod(serializableProxy), ByteBuddyProxyHelper.resolveIdSetterMethod(serializableProxy), serializableProxy.getComponentIdType(), null, ReflectHelper.overridesEquals(serializableProxy.getPersistentClass()));
        try {
            Class proxyClass = this.buildProxy(serializableProxy.getPersistentClass(), serializableProxy.getInterfaces());
            HibernateProxy proxy = (HibernateProxy)proxyClass.newInstance();
            ((ProxyConfiguration)((Object)proxy)).$$_hibernate_set_interceptor(interceptor);
            return proxy;
        }
        catch (Throwable t) {
            String message = LOG.bytecodeEnhancementFailed(serializableProxy.getEntityName());
            LOG.error(message, t);
            throw new HibernateException(message, t);
        }
    }

    private static Method resolveIdGetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierGetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierGetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierGetterMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id getter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierGetterMethodName(), serializableProxy.getIdentifierGetterMethodClass()));
        }
    }

    private static Method resolveIdSetterMethod(SerializableProxy serializableProxy) {
        if (serializableProxy.getIdentifierSetterMethodName() == null) {
            return null;
        }
        try {
            return serializableProxy.getIdentifierSetterMethodClass().getDeclaredMethod(serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodParams());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new HibernateException(String.format(Locale.ENGLISH, "Unable to deserialize proxy [%s, %s]; could not locate id setter method [%s] on entity class [%s]", serializableProxy.getEntityName(), serializableProxy.getId(), serializableProxy.getIdentifierSetterMethodName(), serializableProxy.getIdentifierSetterMethodClass()));
        }
    }
}

