/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.internal.predicate;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class ImplicitNumericExpressionTypeDeterminer {
    private ImplicitNumericExpressionTypeDeterminer() {
    }

    public static Class<? extends Number> determineResultType(Class<? extends Number> ... types) {
        Class<Number> result = Number.class;
        Class<? extends Number>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Number> type = classArray[n2];
            if (Double.class.equals(type)) {
                result = Double.class;
            } else if (Float.class.equals(type)) {
                result = Float.class;
            } else if (BigDecimal.class.equals(type)) {
                result = BigDecimal.class;
            } else if (BigInteger.class.equals(type)) {
                result = BigInteger.class;
            } else if (Long.class.equals(type)) {
                result = Long.class;
            } else if (ImplicitNumericExpressionTypeDeterminer.isIntegralType(type)) {
                result = Integer.class;
            }
            ++n2;
        }
        return result;
    }

    private static boolean isIntegralType(Class<? extends Number> type) {
        return Integer.class.equals(type) || Short.class.equals(type);
    }
}

