/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.spi;

public enum TransactionStatus {
    NOT_ACTIVE,
    ACTIVE,
    COMMITTED,
    ROLLED_BACK,
    MARKED_ROLLBACK,
    FAILED_COMMIT,
    FAILED_ROLLBACK,
    COMMITTING,
    ROLLING_BACK;


    public boolean isOneOf(TransactionStatus ... statuses) {
        TransactionStatus[] transactionStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionStatus status = transactionStatusArray[n2];
            if (this == status) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isNotOneOf(TransactionStatus ... statuses) {
        return !this.isOneOf(statuses);
    }

    public boolean canRollback() {
        return this.isOneOf(ACTIVE, FAILED_COMMIT, MARKED_ROLLBACK);
    }
}

