/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.AssertionFailure;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;

public class ANSIJoinFragment
extends JoinFragment {
    private StringBuilder buffer = new StringBuilder();
    private StringBuilder conditions = new StringBuilder();

    @Override
    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, JoinType joinType) {
        this.addJoin(tableName, alias, fkColumns, pkColumns, joinType, null);
    }

    @Override
    public void addJoin(String rhsTableName, String rhsAlias, String[] lhsColumns, String[] rhsColumns, JoinType joinType, String on) {
        this.buffer.append(switch (joinType) {
            case JoinType.INNER_JOIN -> " inner join ";
            case JoinType.LEFT_OUTER_JOIN -> " left outer join ";
            case JoinType.RIGHT_OUTER_JOIN -> " right outer join ";
            case JoinType.FULL_JOIN -> " full outer join ";
            default -> throw new AssertionFailure("undefined join type");
        }).append(rhsTableName).append(' ').append(rhsAlias).append(" on ");
        int j = 0;
        while (j < lhsColumns.length) {
            this.buffer.append(lhsColumns[j]).append('=').append(rhsAlias).append('.').append(rhsColumns[j]);
            if (j < lhsColumns.length - 1) {
                this.buffer.append(" and ");
            }
            ++j;
        }
        this.addCondition(this.buffer, on);
    }

    @Override
    public void addJoin(String rhsTableName, String rhsAlias, String[][] lhsColumns, String[] rhsColumns, JoinType joinType, String on) {
        this.buffer.append(switch (joinType) {
            case JoinType.INNER_JOIN -> " inner join ";
            case JoinType.LEFT_OUTER_JOIN -> " left outer join ";
            case JoinType.RIGHT_OUTER_JOIN -> " right outer join ";
            case JoinType.FULL_JOIN -> " full outer join ";
            default -> throw new AssertionFailure("undefined join type");
        }).append(rhsTableName).append(' ').append(rhsAlias).append(" on ");
        if (lhsColumns.length > 1) {
            this.buffer.append("(");
        }
        int i = 0;
        while (i < lhsColumns.length) {
            int j = 0;
            while (j < lhsColumns[i].length) {
                this.buffer.append(lhsColumns[i][j]).append('=').append(rhsAlias).append('.').append(rhsColumns[j]);
                if (j < lhsColumns[i].length - 1) {
                    this.buffer.append(" and ");
                }
                ++j;
            }
            if (i < lhsColumns.length - 1) {
                this.buffer.append(" or ");
            }
            ++i;
        }
        if (lhsColumns.length > 1) {
            this.buffer.append(")");
        }
        this.addCondition(this.buffer, on);
    }

    @Override
    public String toFromFragmentString() {
        return this.buffer.toString();
    }

    @Override
    public String toWhereFragmentString() {
        return this.conditions.toString();
    }

    @Override
    public void addJoins(String fromFragment, String whereFragment) {
        this.buffer.append(fromFragment);
    }

    @Override
    public JoinFragment copy() {
        ANSIJoinFragment copy = new ANSIJoinFragment();
        copy.buffer = new StringBuilder(this.buffer.toString());
        return copy;
    }

    public void addCondition(String alias, String[] columns, String condition) {
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            this.conditions.append(" and ").append(alias).append('.').append(column).append(condition);
            ++n2;
        }
    }

    @Override
    public void addCrossJoin(String tableName, String alias) {
        this.buffer.append(", ").append(tableName).append(' ').append(alias);
    }

    @Override
    public void addCondition(String alias, String[] fkColumns, String[] pkColumns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addCondition(String condition) {
        return this.addCondition(this.conditions, condition);
    }

    public void addFromFragmentString(String fromFragmentString) {
        this.buffer.append(fromFragmentString);
    }
}

