/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;

public class OracleJoinFragment
extends JoinFragment {
    private StringBuilder afterFrom = new StringBuilder();
    private StringBuilder afterWhere = new StringBuilder();
    private static final Set OPERATORS = new HashSet();

    static {
        OPERATORS.add(Character.valueOf('='));
        OPERATORS.add(Character.valueOf('<'));
        OPERATORS.add(Character.valueOf('>'));
    }

    @Override
    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, JoinType joinType) {
        this.addCrossJoin(tableName, alias);
        int j = 0;
        while (j < fkColumns.length) {
            this.setHasThetaJoins(true);
            this.afterWhere.append(" and ").append(fkColumns[j]);
            if (joinType == JoinType.RIGHT_OUTER_JOIN || joinType == JoinType.FULL_JOIN) {
                this.afterWhere.append("(+)");
            }
            this.afterWhere.append('=').append(alias).append('.').append(pkColumns[j]);
            if (joinType == JoinType.LEFT_OUTER_JOIN || joinType == JoinType.FULL_JOIN) {
                this.afterWhere.append("(+)");
            }
            ++j;
        }
    }

    public void addJoin(String tableName, String alias, String[][] fkColumns, String[] pkColumns, JoinType joinType) {
        this.addCrossJoin(tableName, alias);
        if (fkColumns.length > 1) {
            this.afterWhere.append("(");
        }
        int i = 0;
        while (i < fkColumns.length) {
            this.afterWhere.append(" and ");
            int j = 0;
            while (j < fkColumns[i].length) {
                this.setHasThetaJoins(true);
                this.afterWhere.append(fkColumns[i][j]);
                if (joinType == JoinType.RIGHT_OUTER_JOIN || joinType == JoinType.FULL_JOIN) {
                    this.afterWhere.append("(+)");
                }
                this.afterWhere.append('=').append(alias).append('.').append(pkColumns[j]);
                if (joinType == JoinType.LEFT_OUTER_JOIN || joinType == JoinType.FULL_JOIN) {
                    this.afterWhere.append("(+)");
                }
                if (j < fkColumns[i].length - 1) {
                    this.afterWhere.append(" and ");
                }
                ++j;
            }
            if (i < fkColumns.length - 1) {
                this.afterWhere.append(" or ");
            }
            ++i;
        }
        if (fkColumns.length > 1) {
            this.afterWhere.append(")");
        }
    }

    @Override
    public String toFromFragmentString() {
        return this.afterFrom.toString();
    }

    @Override
    public String toWhereFragmentString() {
        return this.afterWhere.toString();
    }

    @Override
    public void addJoins(String fromFragment, String whereFragment) {
        this.afterFrom.append(fromFragment);
        this.afterWhere.append(whereFragment);
    }

    @Override
    public JoinFragment copy() {
        OracleJoinFragment copy = new OracleJoinFragment();
        copy.afterFrom = new StringBuilder(this.afterFrom.toString());
        copy.afterWhere = new StringBuilder(this.afterWhere.toString());
        return copy;
    }

    public void addCondition(String alias, String[] columns, String condition) {
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            this.afterWhere.append(" and ").append(alias).append('.').append(column).append(condition);
            ++n2;
        }
    }

    @Override
    public void addCrossJoin(String tableName, String alias) {
        this.afterFrom.append(", ").append(tableName).append(' ').append(alias);
    }

    @Override
    public void addCondition(String alias, String[] fkColumns, String[] pkColumns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addCondition(String condition) {
        return this.addCondition(this.afterWhere, condition);
    }

    public void addFromFragmentString(String fromFragmentString) {
        this.afterFrom.append(fromFragmentString);
    }

    @Override
    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, JoinType joinType, String on) {
        this.addJoin(tableName, alias, fkColumns, pkColumns, joinType);
        if (joinType == JoinType.INNER_JOIN) {
            this.addCondition(on);
        } else if (joinType == JoinType.LEFT_OUTER_JOIN) {
            this.addLeftOuterJoinCondition(on);
        } else {
            throw new UnsupportedOperationException("join type not supported by OracleJoinFragment (use Oracle9iDialect/Oracle10gDialect)");
        }
    }

    @Override
    public void addJoin(String tableName, String alias, String[][] fkColumns, String[] pkColumns, JoinType joinType, String on) {
        this.addJoin(tableName, alias, fkColumns, pkColumns, joinType);
        if (joinType == JoinType.INNER_JOIN) {
            this.addCondition(on);
        } else if (joinType == JoinType.LEFT_OUTER_JOIN) {
            this.addLeftOuterJoinCondition(on);
        } else {
            throw new UnsupportedOperationException("join type not supported by OracleJoinFragment (use Oracle9iDialect/Oracle10gDialect)");
        }
    }

    private void addLeftOuterJoinCondition(String on) {
        StringBuilder buf = new StringBuilder(on);
        int i = 0;
        while (i < buf.length()) {
            boolean isInsertPoint;
            char character = buf.charAt(i);
            boolean bl = isInsertPoint = OPERATORS.contains(Character.valueOf(character)) || character == ' ' && buf.length() > i + 3 && "is ".equals(buf.substring(i + 1, i + 4));
            if (isInsertPoint) {
                buf.insert(i, "(+)");
                i += 3;
            }
            ++i;
        }
        this.addCondition(buf.toString());
    }
}

