/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema;

public enum Action {
    NONE("none"),
    CREATE_ONLY("create", "create-only"),
    DROP("drop"),
    CREATE("drop-and-create", "create"),
    CREATE_DROP(null, "create-drop"),
    VALIDATE(null, "validate"),
    UPDATE(null, "update");

    private final String externalJpaName;
    private final String externalHbm2ddlName;

    private Action(String externalJpaName) {
        this(externalJpaName, externalJpaName);
    }

    private Action(String externalJpaName, String externalHbm2ddlName) {
        this.externalJpaName = externalJpaName;
        this.externalHbm2ddlName = externalHbm2ddlName;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "(externalJpaName=" + this.externalJpaName + ", externalHbm2ddlName=" + this.externalHbm2ddlName + ")";
    }

    public static Action interpretJpaSetting(Object value) {
        Action action;
        if (value == null) {
            return NONE;
        }
        if (Action.class.isInstance(value)) {
            return (Action)((Object)value);
        }
        String name = value.toString().trim();
        if (name.isEmpty() || Action.NONE.externalJpaName.equals(name)) {
            return NONE;
        }
        Action[] actionArray = Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            if (action.externalJpaName != null && action.externalJpaName.equals(name)) {
                return action;
            }
            ++n2;
        }
        actionArray = Action.values();
        n = actionArray.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            if (action.externalHbm2ddlName != null && action.externalHbm2ddlName.equals(name)) {
                return action;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unrecognized JPA schema generation action value : " + value);
    }

    public static Action interpretHbm2ddlSetting(Object value) {
        Action action;
        if (value == null) {
            return NONE;
        }
        if (Action.class.isInstance(value)) {
            return Action.hbm2ddlSetting((Action)((Object)value));
        }
        String name = value.toString().trim();
        if (name.isEmpty() || Action.NONE.externalJpaName.equals(name)) {
            return NONE;
        }
        Action[] actionArray = Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            if (action.externalHbm2ddlName != null && action.externalHbm2ddlName.equals(name)) {
                return Action.hbm2ddlSetting(action);
            }
            ++n2;
        }
        actionArray = Action.values();
        n = actionArray.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            if (action.externalJpaName != null && action.externalJpaName.equals(name)) {
                return Action.hbm2ddlSetting(action);
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unrecognized legacy `hibernate.hbm2ddl.auto` value : `" + value + "`");
    }

    private static Action hbm2ddlSetting(Action action) {
        return action;
    }
}

