/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import org.hibernate.JDBCException;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.naming.DatabaseIdentifier;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.tool.schema.extract.internal.ColumnInformationImpl;
import org.hibernate.tool.schema.extract.internal.ForeignKeyInformationImpl;
import org.hibernate.tool.schema.extract.internal.IndexInformationImpl;
import org.hibernate.tool.schema.extract.internal.PrimaryKeyInformationImpl;
import org.hibernate.tool.schema.extract.internal.TableInformationImpl;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.extract.spi.NameSpaceTablesInformation;
import org.hibernate.tool.schema.extract.spi.PrimaryKeyInformation;
import org.hibernate.tool.schema.extract.spi.SchemaExtractionException;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.spi.SchemaManagementException;

public class InformationExtractorJdbcDatabaseMetaDataImpl
implements InformationExtractor {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(InformationExtractorJdbcDatabaseMetaDataImpl.class);
    private final String[] tableTypes;
    private String[] extraPhysicalTableTypes;
    private final ExtractionContext extractionContext;

    public InformationExtractorJdbcDatabaseMetaDataImpl(ExtractionContext extractionContext) {
        this.extractionContext = extractionContext;
        ConfigurationService configService = extractionContext.getServiceRegistry().getService(ConfigurationService.class);
        String extraPhysycalTableTypesConfig = configService.getSetting("hibernate.hbm2ddl.extra_physical_table_types", StandardConverters.STRING, configService.getSetting("hibernate.hbm2dll.extra_physical_table_types", StandardConverters.STRING, ""));
        if (!"".equals(extraPhysycalTableTypesConfig.trim())) {
            this.extraPhysicalTableTypes = StringHelper.splitTrimmingTokens(",;", extraPhysycalTableTypesConfig, false);
        }
        ArrayList<String> tableTypesList = new ArrayList<String>();
        tableTypesList.add("TABLE");
        tableTypesList.add("VIEW");
        if (ConfigurationHelper.getBoolean("hibernate.synonyms", configService.getSettings(), false)) {
            tableTypesList.add("SYNONYM");
        }
        if (this.extraPhysicalTableTypes != null) {
            Collections.addAll(tableTypesList, this.extraPhysicalTableTypes);
        }
        extractionContext.getJdbcEnvironment().getDialect().augmentRecognizedTableTypes(tableTypesList);
        this.tableTypes = tableTypesList.toArray(new String[tableTypesList.size()]);
    }

    protected IdentifierHelper identifierHelper() {
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper();
    }

    protected JDBCException convertSQLException(SQLException sqlException, String message) {
        return this.extractionContext.getJdbcEnvironment().getSqlExceptionHelper().convert(sqlException, message);
    }

    protected String toMetaDataObjectName(Identifier identifier) {
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper().toMetaDataObjectName(identifier);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean catalogExists(Identifier catalog) {
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getCatalogs();
            try {
                boolean bl = true;
                while (true) {
                    if (bl && !(bl = false)) {
                        if (true) break block13;
                    }
                    String existingCatalogName = resultSet.getString("TABLE_CAT");
                    if (!catalog.getText().equalsIgnoreCase(existingCatalogName)) break block13;
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            {
                block13: {
                    try {
                        resultSet.close();
                        return true;
                    }
                    catch (SQLException sQLException) {}
                    return true;
                }
                if (resultSet.next()) continue;
            }
            try {
                resultSet.close();
                return false;
            }
            catch (SQLException sQLException) {}
            return false;
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Unable to query DatabaseMetaData for existing catalogs");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean schemaExists(Identifier catalog, Identifier schema) {
        try {
            ResultSet resultSet;
            block12: {
                block11: {
                    String catalogFilter = this.determineCatalogFilter(catalog);
                    String schemaFilter = this.determineSchemaFilter(schema);
                    resultSet = this.extractionContext.getJdbcDatabaseMetaData().getSchemas(catalogFilter, schemaFilter);
                    try {
                        if (resultSet.next()) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            resultSet.close();
                            throw throwable;
                        }
                        catch (SQLException sQLException) {}
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                        return false;
                    }
                    catch (SQLException sQLException) {}
                    return false;
                }
                if (!resultSet.next()) break block12;
                String catalogName = catalog == null ? "" : catalog.getCanonicalName();
                String schemaName = schema == null ? "" : schema.getCanonicalName();
                log.debugf("Multiple schemas found with that name [%s.%s]", catalogName, schemaName);
            }
            try {
                resultSet.close();
                return true;
            }
            catch (SQLException sQLException) {}
            return true;
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Unable to query DatabaseMetaData for existing schemas");
        }
    }

    private String determineCatalogFilter(Identifier catalog) throws SQLException {
        Identifier identifierToUse = catalog;
        if (identifierToUse == null) {
            identifierToUse = this.extractionContext.getDefaultCatalog();
        }
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper().toMetaDataCatalogName(identifierToUse);
    }

    private String determineSchemaFilter(Identifier schema) throws SQLException {
        Identifier identifierToUse = schema;
        if (identifierToUse == null) {
            identifierToUse = this.extractionContext.getDefaultSchema();
        }
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper().toMetaDataSchemaName(identifierToUse);
    }

    private TableInformation extractTableInformation(ResultSet resultSet) throws SQLException {
        QualifiedTableName tableName = this.extractTableName(resultSet);
        TableInformationImpl tableInformation = new TableInformationImpl(this, this.identifierHelper(), tableName, this.isPhysicalTableType(resultSet.getString("TABLE_TYPE")), resultSet.getString("REMARKS"));
        return tableInformation;
    }

    @Override
    public TableInformation getTable(Identifier catalog, Identifier schema, Identifier tableName) {
        TableInformation tableInformation;
        if (catalog != null || schema != null) {
            return this.locateTableInNamespace(catalog, schema, tableName);
        }
        TableInformation tableInfo = null;
        if ((this.extractionContext.getJdbcEnvironment().getCurrentCatalog() != null || this.extractionContext.getJdbcEnvironment().getCurrentSchema() != null) && (tableInfo = this.locateTableInNamespace(this.extractionContext.getJdbcEnvironment().getCurrentCatalog(), this.extractionContext.getJdbcEnvironment().getCurrentSchema(), tableName)) != null) {
            return tableInfo;
        }
        if ((this.extractionContext.getDefaultCatalog() != null || this.extractionContext.getDefaultSchema() != null) && (tableInfo = this.locateTableInNamespace(this.extractionContext.getDefaultCatalog(), this.extractionContext.getDefaultSchema(), tableName)) != null) {
            return tableInfo;
        }
        String tableNameFilter = this.toMetaDataObjectName(tableName);
        ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(null, null, tableNameFilter, this.tableTypes);
        try {
            tableInformation = this.processTableResults(null, null, tableName, resultSet);
        }
        catch (Throwable throwable) {
            try {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            catch (SQLException sqlException) {
                throw this.convertSQLException(sqlException, "Error accessing table metadata");
            }
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {}
        return tableInformation;
    }

    @Override
    public NameSpaceTablesInformation getTables(Identifier catalog, Identifier schema) {
        String catalogFilter = null;
        String schemaFilter = null;
        if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsCatalogs()) {
            catalogFilter = catalog == null ? (this.extractionContext.getJdbcEnvironment().getCurrentCatalog() != null ? this.toMetaDataObjectName(this.extractionContext.getJdbcEnvironment().getCurrentCatalog()) : (this.extractionContext.getDefaultCatalog() != null ? this.toMetaDataObjectName(this.extractionContext.getDefaultCatalog()) : "")) : this.toMetaDataObjectName(catalog);
        }
        if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsSchemas()) {
            schemaFilter = schema == null ? (this.extractionContext.getJdbcEnvironment().getCurrentSchema() != null ? this.toMetaDataObjectName(this.extractionContext.getJdbcEnvironment().getCurrentSchema()) : (this.extractionContext.getDefaultSchema() != null ? this.toMetaDataObjectName(this.extractionContext.getDefaultSchema()) : "")) : this.toMetaDataObjectName(schema);
        }
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(catalogFilter, schemaFilter, "%", this.tableTypes);
            NameSpaceTablesInformation tablesInformation = this.processTableResults(resultSet);
            this.populateTablesWithColumns(catalogFilter, schemaFilter, tablesInformation);
            return tablesInformation;
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Error accessing table metadata");
        }
    }

    private void populateTablesWithColumns(String catalogFilter, String schemaFilter, NameSpaceTablesInformation tables) {
        try (ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getColumns(catalogFilter, schemaFilter, null, "%");){
            String currentTableName = "";
            TableInformation currentTable = null;
            while (resultSet.next()) {
                if (!currentTableName.equals(resultSet.getString("TABLE_NAME"))) {
                    currentTableName = resultSet.getString("TABLE_NAME");
                    currentTable = tables.getTableInformation(currentTableName);
                }
                if (currentTable == null) continue;
                ColumnInformationImpl columnInformation = new ColumnInformationImpl(currentTable, DatabaseIdentifier.toIdentifier(resultSet.getString("COLUMN_NAME")), resultSet.getInt("DATA_TYPE"), new StringTokenizer(resultSet.getString("TYPE_NAME"), "() ").nextToken(), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), this.interpretTruthValue(resultSet.getString("IS_NULLABLE")));
                currentTable.addColumn(columnInformation);
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing tables metadata");
        }
    }

    private NameSpaceTablesInformation processTableResults(ResultSet resultSet) throws SQLException {
        NameSpaceTablesInformation nameSpaceTablesInformation;
        try {
            NameSpaceTablesInformation tables = new NameSpaceTablesInformation(this.identifierHelper());
            while (resultSet.next()) {
                TableInformation tableInformation = this.extractTableInformation(resultSet);
                tables.addTableInformation(tableInformation);
            }
            nameSpaceTablesInformation = tables;
        }
        catch (Throwable throwable) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {}
        return nameSpaceTablesInformation;
    }

    private TableInformation locateTableInNamespace(Identifier catalog, Identifier schema, Identifier tableName) {
        String schemaFilter;
        String catalogFilter;
        Identifier catalogToUse = null;
        Identifier schemaToUse = null;
        if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsCatalogs()) {
            if (catalog == null) {
                String defaultCatalog = "";
                if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsCatalogs()) {
                    try {
                        defaultCatalog = this.extractionContext.getJdbcConnection().getCatalog();
                    }
                    catch (SQLException sQLException) {}
                }
                catalogFilter = defaultCatalog;
            } else {
                catalogToUse = catalog;
                catalogFilter = this.toMetaDataObjectName(catalog);
            }
        } else {
            catalogFilter = null;
        }
        if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsSchemas()) {
            if (schema == null) {
                schemaFilter = "";
            } else {
                schemaToUse = schema;
                schemaFilter = this.toMetaDataObjectName(schema);
            }
        } else {
            schemaFilter = null;
        }
        String tableNameFilter = this.toMetaDataObjectName(tableName);
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(catalogFilter, schemaFilter, tableNameFilter, this.tableTypes);
            return this.processTableResults(catalogToUse, schemaToUse, tableName, resultSet);
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Error accessing table metadata");
        }
    }

    private TableInformation processTableResults(Identifier catalog, Identifier schema, Identifier tableName, ResultSet resultSet) throws SQLException {
        TableInformation tableInformation;
        try {
            boolean found = false;
            TableInformation tableInformation2 = null;
            while (resultSet.next()) {
                if (!tableName.equals(Identifier.toIdentifier(resultSet.getString("TABLE_NAME"), tableName.isQuoted()))) continue;
                if (found) {
                    log.multipleTablesFound(tableName.render());
                    String catalogName = catalog == null ? "" : catalog.render();
                    String schemaName = schema == null ? "" : schema.render();
                    throw new SchemaExtractionException(String.format(Locale.ENGLISH, "More than one table found in namespace (%s, %s) : %s", catalogName, schemaName, tableName.render()));
                }
                found = true;
                tableInformation2 = this.extractTableInformation(resultSet);
                this.addColumns(tableInformation2);
            }
            if (!found) {
                log.tableNotFound(tableName.render());
            }
            tableInformation = tableInformation2;
        }
        catch (Throwable throwable) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {}
        return tableInformation;
    }

    protected boolean isPhysicalTableType(String tableType) {
        if (this.extraPhysicalTableTypes == null) {
            return "TABLE".equalsIgnoreCase(tableType);
        }
        if ("TABLE".equalsIgnoreCase(tableType)) {
            return true;
        }
        String[] stringArray = this.extraPhysicalTableTypes;
        int n = this.extraPhysicalTableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String extraPhysicalTableType = stringArray[n2];
            if (extraPhysicalTableType.equalsIgnoreCase(tableType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addColumns(TableInformation tableInformation) {
        QualifiedTableName tableName = tableInformation.getName();
        Identifier catalog = tableName.getCatalogName();
        Identifier schema = tableName.getSchemaName();
        String catalogFilter = catalog == null ? "" : catalog.getText();
        String schemaFilter = schema == null ? "" : schema.getText();
        try (ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getColumns(catalogFilter, schemaFilter, tableName.getTableName().getText(), "%");){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                ColumnInformationImpl columnInformation = new ColumnInformationImpl(tableInformation, DatabaseIdentifier.toIdentifier(columnName), resultSet.getInt("DATA_TYPE"), new StringTokenizer(resultSet.getString("TYPE_NAME"), "() ").nextToken(), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), this.interpretTruthValue(resultSet.getString("IS_NULLABLE")));
                tableInformation.addColumn(columnInformation);
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + tableName.toString());
        }
    }

    private TruthValue interpretTruthValue(String nullable) {
        if ("yes".equalsIgnoreCase(nullable)) {
            return TruthValue.TRUE;
        }
        if ("no".equalsIgnoreCase(nullable)) {
            return TruthValue.FALSE;
        }
        return TruthValue.UNKNOWN;
    }

    @Override
    public PrimaryKeyInformation getPrimaryKey(TableInformationImpl tableInformation) {
        DatabaseIdentifier pkIdentifier;
        ArrayList<ColumnInformation> pkColumns;
        block13: {
            QualifiedTableName tableName = tableInformation.getName();
            Identifier catalog = tableName.getCatalogName();
            Identifier schema = tableName.getSchemaName();
            String catalogFilter = catalog == null ? "" : catalog.getText();
            String schemaFilter = schema == null ? "" : schema.getText();
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getPrimaryKeys(catalogFilter, schemaFilter, tableInformation.getName().getTableName().getText());
            pkColumns = new ArrayList<ColumnInformation>();
            boolean firstPass = true;
            pkIdentifier = null;
            try {
                while (resultSet.next()) {
                    DatabaseIdentifier currentPkIdentifier;
                    String currentPkName = resultSet.getString("PK_NAME");
                    DatabaseIdentifier databaseIdentifier = currentPkIdentifier = currentPkName == null ? null : DatabaseIdentifier.toIdentifier(currentPkName);
                    if (firstPass) {
                        pkIdentifier = currentPkIdentifier;
                        firstPass = false;
                    } else if (!Objects.equals(pkIdentifier, currentPkIdentifier)) {
                        throw new SchemaExtractionException(String.format("Encountered primary keys differing name on table %s", tableInformation.getName().toString()));
                    }
                    int columnPosition = resultSet.getInt("KEY_SEQ");
                    DatabaseIdentifier columnIdentifier = DatabaseIdentifier.toIdentifier(resultSet.getString("COLUMN_NAME"));
                    ColumnInformation column = tableInformation.getColumn(columnIdentifier);
                    pkColumns.add(columnPosition - 1, column);
                }
            }
            finally {
                resultSet.close();
            }
            if (!firstPass) break block13;
            return null;
        }
        try {
            int i = 0;
            while (i < pkColumns.size()) {
                if (pkColumns.get(i) == null) {
                    throw new SchemaExtractionException("Primary Key information was missing for KEY_SEQ = " + (i + 1));
                }
                ++i;
            }
            return new PrimaryKeyInformationImpl(pkIdentifier, pkColumns);
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error while reading primary key meta data for " + tableInformation.getName().toString());
        }
    }

    @Override
    public Iterable<IndexInformation> getIndexes(TableInformation tableInformation) {
        HashMap<DatabaseIdentifier, IndexInformationImpl.Builder> builders = new HashMap<DatabaseIdentifier, IndexInformationImpl.Builder>();
        QualifiedTableName tableName = tableInformation.getName();
        Identifier catalog = tableName.getCatalogName();
        Identifier schema = tableName.getSchemaName();
        String catalogFilter = catalog == null ? "" : catalog.getText();
        String schemaFilter = schema == null ? "" : schema.getText();
        try (ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getIndexInfo(catalogFilter, schemaFilter, tableName.getTableName().getText(), false, true);){
            while (resultSet.next()) {
                DatabaseIdentifier columnIdentifier;
                ColumnInformation columnInformation;
                if (resultSet.getShort("TYPE") == 0) continue;
                DatabaseIdentifier indexIdentifier = DatabaseIdentifier.toIdentifier(resultSet.getString("INDEX_NAME"));
                IndexInformationImpl.Builder builder = (IndexInformationImpl.Builder)builders.get(indexIdentifier);
                if (builder == null) {
                    builder = IndexInformationImpl.builder(indexIdentifier);
                    builders.put(indexIdentifier, builder);
                }
                if ((columnInformation = tableInformation.getColumn(columnIdentifier = DatabaseIdentifier.toIdentifier(resultSet.getString("COLUMN_NAME")))) == null) {
                    log.logCannotLocateIndexColumnInformation(columnIdentifier.getText(), indexIdentifier.getText());
                }
                builder.addColumn(columnInformation);
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing index information: " + tableInformation.getName().toString());
        }
        ArrayList<IndexInformation> indexes = new ArrayList<IndexInformation>();
        for (IndexInformationImpl.Builder builder : builders.values()) {
            IndexInformationImpl index = builder.build();
            indexes.add(index);
        }
        return indexes;
    }

    @Override
    public Iterable<ForeignKeyInformation> getForeignKeys(TableInformation tableInformation) {
        HashMap<DatabaseIdentifier, ForeignKeyBuilder> fkBuilders = new HashMap<DatabaseIdentifier, ForeignKeyBuilder>();
        QualifiedTableName tableName = tableInformation.getName();
        Identifier catalog = tableName.getCatalogName();
        Identifier schema = tableName.getSchemaName();
        String catalogFilter = catalog == null ? "" : catalog.getText();
        String schemaFilter = schema == null ? "" : schema.getText();
        try (ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getImportedKeys(catalogFilter, schemaFilter, tableInformation.getName().getTableName().getText());){
            while (resultSet.next()) {
                DatabaseIdentifier fkIdentifier = DatabaseIdentifier.toIdentifier(resultSet.getString("FK_NAME"));
                ForeignKeyBuilder fkBuilder = (ForeignKeyBuilder)fkBuilders.get(fkIdentifier);
                if (fkBuilder == null) {
                    fkBuilder = this.generateForeignKeyBuilder(fkIdentifier);
                    fkBuilders.put(fkIdentifier, fkBuilder);
                }
                QualifiedTableName incomingPkTableName = this.extractKeyTableName(resultSet, "PK");
                TableInformation pkTableInformation = this.extractionContext.getDatabaseObjectAccess().locateTableInformation(incomingPkTableName);
                if (pkTableInformation == null) continue;
                DatabaseIdentifier fkColumnIdentifier = DatabaseIdentifier.toIdentifier(resultSet.getString("FKCOLUMN_NAME"));
                DatabaseIdentifier pkColumnIdentifier = DatabaseIdentifier.toIdentifier(resultSet.getString("PKCOLUMN_NAME"));
                fkBuilder.addColumnMapping(tableInformation.getColumn(fkColumnIdentifier), pkTableInformation.getColumn(pkColumnIdentifier));
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + tableInformation.getName().toString());
        }
        ArrayList<ForeignKeyInformation> fks = new ArrayList<ForeignKeyInformation>();
        for (ForeignKeyBuilder fkBuilder : fkBuilders.values()) {
            ForeignKeyInformation fk = fkBuilder.build();
            fks.add(fk);
        }
        return fks;
    }

    private ForeignKeyBuilder generateForeignKeyBuilder(Identifier fkIdentifier) {
        return new ForeignKeyBuilderImpl(fkIdentifier);
    }

    private QualifiedTableName extractKeyTableName(ResultSet resultSet, String prefix) throws SQLException {
        String incomingCatalogName = resultSet.getString(String.valueOf(prefix) + "TABLE_CAT");
        String incomingSchemaName = resultSet.getString(String.valueOf(prefix) + "TABLE_SCHEM");
        String incomingTableName = resultSet.getString(String.valueOf(prefix) + "TABLE_NAME");
        DatabaseIdentifier catalog = DatabaseIdentifier.toIdentifier(incomingCatalogName);
        DatabaseIdentifier schema = DatabaseIdentifier.toIdentifier(incomingSchemaName);
        DatabaseIdentifier table = DatabaseIdentifier.toIdentifier(incomingTableName);
        return new QualifiedTableName(catalog, schema, table);
    }

    private QualifiedTableName extractTableName(ResultSet resultSet) throws SQLException {
        String incomingCatalogName = resultSet.getString("TABLE_CAT");
        String incomingSchemaName = resultSet.getString("TABLE_SCHEM");
        String incomingTableName = resultSet.getString("TABLE_NAME");
        DatabaseIdentifier catalog = DatabaseIdentifier.toIdentifier(incomingCatalogName);
        DatabaseIdentifier schema = DatabaseIdentifier.toIdentifier(incomingSchemaName);
        DatabaseIdentifier table = DatabaseIdentifier.toIdentifier(incomingTableName);
        return new QualifiedTableName(catalog, schema, table);
    }

    protected static interface ForeignKeyBuilder {
        public ForeignKeyBuilder addColumnMapping(ColumnInformation var1, ColumnInformation var2);

        public ForeignKeyInformation build();
    }

    protected static class ForeignKeyBuilderImpl
    implements ForeignKeyBuilder {
        private final Identifier fkIdentifier;
        private final List<ForeignKeyInformation.ColumnReferenceMapping> columnMappingList = new ArrayList<ForeignKeyInformation.ColumnReferenceMapping>();

        public ForeignKeyBuilderImpl(Identifier fkIdentifier) {
            this.fkIdentifier = fkIdentifier;
        }

        @Override
        public ForeignKeyBuilder addColumnMapping(ColumnInformation referencing, ColumnInformation referenced) {
            this.columnMappingList.add(new ForeignKeyInformationImpl.ColumnReferenceMappingImpl(referencing, referenced));
            return this;
        }

        @Override
        public ForeignKeyInformationImpl build() {
            if (this.columnMappingList.isEmpty()) {
                throw new SchemaManagementException("Attempt to resolve foreign key metadata from JDBC metadata failed to find column mappings for foreign key named [" + this.fkIdentifier.getText() + "]");
            }
            return new ForeignKeyInformationImpl(this.fkIdentifier, this.columnMappingList);
        }
    }
}

