/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.factories;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.hildan.fxgson.adapters.properties.ListPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.MapPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.ObjectPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.SetPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.StringPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.BooleanPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.DoublePropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.FloatPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.IntegerPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.LongPropertyTypeAdapter;
import org.hildan.fxgson.factories.TypeHelper;

public class JavaFxPropertyTypeAdapterFactory
implements TypeAdapterFactory {
    private final boolean strictProperties;
    private final boolean strictPrimitives;

    public JavaFxPropertyTypeAdapterFactory() {
        this(true, true);
    }

    public JavaFxPropertyTypeAdapterFactory(boolean throwOnNullProperties, boolean throwOnNullPrimitives) {
        this.strictProperties = throwOnNullProperties;
        this.strictPrimitives = throwOnNullPrimitives;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class cls = type.getRawType();
        if (!Property.class.isAssignableFrom(cls)) {
            return null;
        }
        if (BooleanProperty.class.isAssignableFrom(cls)) {
            return new BooleanPropertyTypeAdapter((TypeAdapter<Boolean>)gson.getAdapter(Boolean.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (IntegerProperty.class.isAssignableFrom(cls)) {
            return new IntegerPropertyTypeAdapter((TypeAdapter<Integer>)gson.getAdapter(Integer.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (LongProperty.class.isAssignableFrom(cls)) {
            return new LongPropertyTypeAdapter((TypeAdapter<Long>)gson.getAdapter(Long.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (FloatProperty.class.isAssignableFrom(cls)) {
            return new FloatPropertyTypeAdapter((TypeAdapter<Float>)gson.getAdapter(Float.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (DoubleProperty.class.isAssignableFrom(cls)) {
            return new DoublePropertyTypeAdapter((TypeAdapter<Double>)gson.getAdapter(Double.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (StringProperty.class.isAssignableFrom(cls)) {
            return new StringPropertyTypeAdapter((TypeAdapter<String>)gson.getAdapter(String.class), this.strictProperties);
        }
        if (ListProperty.class.equals((Object)cls) || SimpleListProperty.class.equals((Object)cls)) {
            TypeAdapter delegate = gson.getAdapter(TypeHelper.withRawType(type, ObservableList.class));
            return new ListPropertyTypeAdapter(delegate, this.strictProperties);
        }
        if (SetProperty.class.equals((Object)cls) || SimpleSetProperty.class.equals((Object)cls)) {
            TypeAdapter delegate = gson.getAdapter(TypeHelper.withRawType(type, ObservableSet.class));
            return new SetPropertyTypeAdapter(delegate, this.strictProperties);
        }
        if (MapProperty.class.equals((Object)cls) || SimpleMapProperty.class.equals((Object)cls)) {
            TypeAdapter delegate = gson.getAdapter(TypeHelper.withRawType(type, ObservableMap.class));
            return new MapPropertyTypeAdapter(delegate, this.strictProperties);
        }
        if (Property.class.equals((Object)cls) || ObjectProperty.class.equals((Object)cls) || SimpleObjectProperty.class.equals((Object)cls)) {
            Type[] typeParams = ((ParameterizedType)type.getType()).getActualTypeArguments();
            Type param = typeParams[0];
            TypeAdapter delegate = gson.getAdapter(TypeToken.get((Type)param));
            return new ObjectPropertyTypeAdapter(delegate, this.strictProperties);
        }
        return null;
    }
}

