/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassExtendsTypeTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EmptyTypeTarget;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.FieldInternal;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReaderImpl;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodInternal;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.MethodParameterTypeTarget;
import org.jboss.jandex.PackedDataInputStream;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.ThrowsTypeTarget;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeParameterBoundTypeTarget;
import org.jboss.jandex.TypeParameterTypeTarget;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.Utils;
import org.jboss.jandex.VoidType;
import org.jboss.jandex.WildcardType;

final class IndexReaderV2
extends IndexReaderImpl {
    static final int MIN_VERSION = 6;
    static final int MAX_VERSION = 9;
    static final int MAX_DATA_VERSION = 4;
    private static final byte NULL_TARGET_TAG = 0;
    private static final byte FIELD_TAG = 1;
    private static final byte METHOD_TAG = 2;
    private static final byte METHOD_PARAMATER_TAG = 3;
    private static final byte CLASS_TAG = 4;
    private static final byte EMPTY_TYPE_TAG = 5;
    private static final byte CLASS_EXTENDS_TYPE_TAG = 6;
    private static final byte TYPE_PARAMETER_TAG = 7;
    private static final byte TYPE_PARAMETER_BOUND_TAG = 8;
    private static final byte METHOD_PARAMETER_TYPE_TAG = 9;
    private static final byte THROWS_TYPE_TAG = 10;
    private static final int AVALUE_BYTE = 1;
    private static final int AVALUE_SHORT = 2;
    private static final int AVALUE_INT = 3;
    private static final int AVALUE_CHAR = 4;
    private static final int AVALUE_FLOAT = 5;
    private static final int AVALUE_DOUBLE = 6;
    private static final int AVALUE_LONG = 7;
    private static final int AVALUE_BOOLEAN = 8;
    private static final int AVALUE_STRING = 9;
    private static final int AVALUE_CLASS = 10;
    private static final int AVALUE_ENUM = 11;
    private static final int AVALUE_ARRAY = 12;
    private static final int AVALUE_NESTED = 13;
    private static final int HAS_ENCLOSING_METHOD = 1;
    private static final byte[] INIT_METHOD_NAME = Utils.toUTF8("<init>");
    private PackedDataInputStream input;
    private byte[][] byteTable;
    private String[] stringTable;
    private DotName[] nameTable;
    private Type[] typeTable;
    private Type[][] typeListTable;
    private AnnotationInstance[] annotationTable;
    private MethodInternal[] methodTable;
    private FieldInternal[] fieldTable;

    IndexReaderV2(PackedDataInputStream input) {
        this.input = input;
    }

    @Override
    Index read(int version) throws IOException {
        try {
            PackedDataInputStream stream = this.input;
            int annotationsSize = stream.readPackedU32();
            int implementorsSize = stream.readPackedU32();
            int subclassesSize = stream.readPackedU32();
            this.readByteTable(stream);
            this.readStringTable(stream);
            this.readNameTable(stream);
            this.typeTable = new Type[stream.readPackedU32() + 1];
            this.typeListTable = new Type[stream.readPackedU32() + 1][];
            this.annotationTable = new AnnotationInstance[stream.readPackedU32() + 1];
            this.readTypeTable(stream);
            this.readTypeListTable(stream);
            this.readMethodTable(stream, version);
            this.readFieldTable(stream);
            Index index = this.readClasses(stream, annotationsSize, implementorsSize, subclassesSize, version);
            return index;
        }
        finally {
            this.byteTable = null;
            this.stringTable = null;
            this.nameTable = null;
            this.typeTable = null;
            this.typeListTable = null;
            this.annotationTable = null;
            this.methodTable = null;
            this.fieldTable = null;
        }
    }

    private void readByteTable(PackedDataInputStream stream) throws IOException {
        int size = stream.readPackedU32() + 1;
        byte[][] byArrayArray = new byte[size][];
        this.byteTable = byArrayArray;
        byte[][] byteTable = byArrayArray;
        int i = 1;
        while (i < size) {
            int len = stream.readPackedU32();
            byteTable[i] = new byte[len];
            stream.readFully(byteTable[i], 0, len);
            ++i;
        }
    }

    private void readStringTable(PackedDataInputStream stream) throws IOException {
        int size = stream.readPackedU32() + 1;
        this.stringTable = new String[size];
        String[] stringTable = this.stringTable;
        int i = 1;
        while (i < size) {
            stringTable[i] = stream.readUTF();
            ++i;
        }
    }

    private void readNameTable(PackedDataInputStream stream) throws IOException {
        int entries = stream.readPackedU32() + 1;
        int lastDepth = -1;
        DotName curr = null;
        this.nameTable = new DotName[entries];
        int i = 1;
        while (i < entries) {
            int depth = stream.readPackedU32();
            boolean inner = (depth & 1) == 1;
            String local = this.stringTable[stream.readPackedU32()];
            if ((depth >>= 1) <= lastDepth) {
                while (lastDepth-- >= depth) {
                    assert (curr != null);
                    curr = curr.prefix();
                }
            }
            this.nameTable[i] = curr = new DotName(curr, local, true, inner);
            lastDepth = depth;
            ++i;
        }
    }

    private void readTypeTable(PackedDataInputStream stream) throws IOException {
        int i = 1;
        while (i < this.typeTable.length) {
            this.typeTable[i] = this.readTypeEntry(stream);
            ++i;
        }
    }

    private int findNextNull(Object[] array, int start) {
        while (start < array.length) {
            if (array[start] == null) {
                return start;
            }
            ++start;
        }
        return array.length;
    }

    private void readTypeListTable(PackedDataInputStream stream) throws IOException {
        Type[][] typeListTable = this.typeListTable;
        int i = this.findNextNull((Object[])typeListTable, 1);
        while (i < typeListTable.length) {
            typeListTable[i] = this.readTypeListEntry(stream);
            i = this.findNextNull((Object[])typeListTable, i);
        }
    }

    private AnnotationInstance[] readAnnotations(PackedDataInputStream stream, AnnotationTarget target) throws IOException {
        int size = stream.readPackedU32();
        if (size == 0) {
            return AnnotationInstance.EMPTY_ARRAY;
        }
        AnnotationInstance[] annotations = new AnnotationInstance[size];
        int i = 0;
        while (i < size) {
            int reference = stream.readPackedU32();
            if (this.annotationTable[reference] == null) {
                this.annotationTable[reference] = this.readAnnotationEntry(stream, target);
            }
            annotations[i] = this.annotationTable[reference];
            ++i;
        }
        return annotations;
    }

    private AnnotationValue[] readAnnotationValues(PackedDataInputStream stream) throws IOException {
        int numValues = stream.readPackedU32();
        AnnotationValue[] values = new AnnotationValue[numValues];
        int i = 0;
        while (i < numValues) {
            AnnotationValue value;
            values[i] = value = this.readAnnotationValue(stream);
            ++i;
        }
        return values;
    }

    private AnnotationValue readAnnotationValue(PackedDataInputStream stream) throws IOException {
        String name = this.stringTable[stream.readPackedU32()];
        byte tag = stream.readByte();
        return switch (tag) {
            case 1 -> new AnnotationValue.ByteValue(name, stream.readByte());
            case 2 -> new AnnotationValue.ShortValue(name, (short)stream.readPackedU32());
            case 3 -> new AnnotationValue.IntegerValue(name, stream.readPackedU32());
            case 4 -> new AnnotationValue.CharacterValue(name, (char)stream.readPackedU32());
            case 5 -> new AnnotationValue.FloatValue(name, stream.readFloat());
            case 6 -> new AnnotationValue.DoubleValue(name, stream.readDouble());
            case 7 -> new AnnotationValue.LongValue(name, stream.readLong());
            case 8 -> new AnnotationValue.BooleanValue(name, stream.readBoolean());
            case 9 -> new AnnotationValue.StringValue(name, this.stringTable[stream.readPackedU32()]);
            case 10 -> new AnnotationValue.ClassValue(name, this.typeTable[stream.readPackedU32()]);
            case 11 -> new AnnotationValue.EnumValue(name, this.nameTable[stream.readPackedU32()], this.stringTable[stream.readPackedU32()]);
            case 12 -> new AnnotationValue.ArrayValue(name, this.readAnnotationValues(stream));
            case 13 -> {
                int reference = stream.readPackedU32();
                AnnotationInstance nestedInstance = this.annotationTable[reference];
                if (nestedInstance == null) {
                    nestedInstance = this.annotationTable[reference] = this.readAnnotationEntry(stream, null);
                }
                yield new AnnotationValue.NestedAnnotation(name, nestedInstance);
            }
            default -> throw new IllegalStateException("Invalid annotation value tag:" + tag);
        };
    }

    private AnnotationInstance readAnnotationEntry(PackedDataInputStream stream, AnnotationTarget caller) throws IOException {
        DotName name = this.nameTable[stream.readPackedU32()];
        AnnotationTarget target = this.readAnnotationTarget(stream, caller);
        AnnotationValue[] values = this.readAnnotationValues(stream);
        return new AnnotationInstance(name, target, values);
    }

    private Type[] readTypeListReference(PackedDataInputStream stream) throws IOException {
        int reference = stream.readPackedU32();
        Type[] types = this.typeListTable[reference];
        if (types != null) {
            return types;
        }
        this.typeListTable[reference] = this.readTypeListEntry(stream);
        return this.typeListTable[reference];
    }

    private Type[] readTypeListEntry(PackedDataInputStream stream) throws IOException {
        int size = stream.readPackedU32();
        if (size == 0) {
            return Type.EMPTY_ARRAY;
        }
        Type[] types = new Type[size];
        int i = 0;
        while (i < size) {
            types[i] = this.typeTable[stream.readPackedU32()];
            ++i;
        }
        return types;
    }

    private Type readTypeEntry(PackedDataInputStream stream) throws IOException {
        Type.Kind kind = Type.Kind.fromOrdinal(stream.readUnsignedByte());
        switch (kind) {
            case CLASS: {
                DotName name = this.nameTable[stream.readPackedU32()];
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return new ClassType(name, annotations);
            }
            case ARRAY: {
                int dimensions = stream.readPackedU32();
                Type component = this.typeTable[stream.readPackedU32()];
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return new ArrayType(component, dimensions, annotations);
            }
            case PRIMITIVE: {
                int primitive = stream.readUnsignedByte();
                PrimitiveType type = PrimitiveType.fromOridinal(primitive);
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return annotations.length > 0 ? ((Type)type).copyType(annotations) : type;
            }
            case VOID: {
                VoidType type = VoidType.VOID;
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return annotations.length > 0 ? ((Type)type).copyType(annotations) : type;
            }
            case TYPE_VARIABLE: {
                String identifier = this.stringTable[stream.readPackedU32()];
                Type[] bounds = this.readTypeListReference(stream);
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return new TypeVariable(identifier, bounds, annotations);
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                String identifier = this.stringTable[stream.readPackedU32()];
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return new UnresolvedTypeVariable(identifier, annotations);
            }
            case WILDCARD_TYPE: {
                boolean isExtends = stream.readPackedU32() == 1;
                Type bound = this.typeTable[stream.readPackedU32()];
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return new WildcardType(bound, isExtends, annotations);
            }
            case PARAMETERIZED_TYPE: {
                DotName name = this.nameTable[stream.readPackedU32()];
                int reference = stream.readPackedU32();
                Type owner = this.typeTable[reference];
                Type[] parameters = this.readTypeListReference(stream);
                AnnotationInstance[] annotations = this.readAnnotations(stream, null);
                return new ParameterizedType(name, parameters, owner, annotations);
            }
        }
        throw new IllegalStateException("Unrecognized type: " + (Object)((Object)kind));
    }

    private AnnotationTarget readAnnotationTarget(PackedDataInputStream stream, AnnotationTarget caller) throws IOException {
        byte tag = stream.readByte();
        switch (tag) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 4: {
                return caller;
            }
            case 3: {
                short parameter = (short)stream.readPackedU32();
                return new MethodParameterInfo((MethodInfo)caller, parameter);
            }
            case 5: {
                Type target = this.typeTable[stream.readPackedU32()];
                boolean isReceiver = stream.readPackedU32() == 1;
                return new EmptyTypeTarget(caller, target, isReceiver);
            }
            case 6: {
                Type target = this.typeTable[stream.readPackedU32()];
                int pos = stream.readPackedU32();
                return new ClassExtendsTypeTarget(caller, target, pos);
            }
            case 7: {
                Type target = this.typeTable[stream.readPackedU32()];
                int pos = stream.readPackedU32();
                return new TypeParameterTypeTarget(caller, target, pos);
            }
            case 8: {
                Type target = this.typeTable[stream.readPackedU32()];
                int pos = stream.readPackedU32();
                int bound = stream.readPackedU32();
                return new TypeParameterBoundTypeTarget(caller, target, pos, bound);
            }
            case 9: {
                Type target = this.typeTable[stream.readPackedU32()];
                int pos = stream.readPackedU32();
                return new MethodParameterTypeTarget(caller, target, pos);
            }
            case 10: {
                Type target = this.typeTable[stream.readPackedU32()];
                int pos = stream.readPackedU32();
                return new ThrowsTypeTarget(caller, target, pos);
            }
        }
        throw new IllegalStateException("Invalid tag: " + tag);
    }

    private void readMethodTable(PackedDataInputStream stream, int version) throws IOException {
        int size = stream.readPackedU32() + 1;
        this.methodTable = new MethodInternal[size];
        int i = 1;
        while (i < size) {
            this.methodTable[i] = this.readMethodEntry(stream, version);
            ++i;
        }
    }

    private void readFieldTable(PackedDataInputStream stream) throws IOException {
        int size = stream.readPackedU32() + 1;
        this.fieldTable = new FieldInternal[size];
        int i = 1;
        while (i < size) {
            this.fieldTable[i] = this.readFieldEntry(stream);
            ++i;
        }
    }

    private MethodInternal readMethodEntry(PackedDataInputStream stream, int version) throws IOException {
        int size;
        byte[] name = this.byteTable[stream.readPackedU32()];
        short flags = (short)stream.readPackedU32();
        Type[] typeParameters = this.typeListTable[stream.readPackedU32()];
        int reference = stream.readPackedU32();
        Type receiverType = this.typeTable[reference];
        Type returnType = this.typeTable[stream.readPackedU32()];
        Type[] parameters = this.typeListTable[stream.readPackedU32()];
        Type[] exceptions = this.typeListTable[stream.readPackedU32()];
        AnnotationValue defaultValue = null;
        if (version >= 7) {
            boolean hasDefaultValue;
            boolean bl = hasDefaultValue = stream.readByte() > 0;
            if (hasDefaultValue) {
                defaultValue = this.readAnnotationValue(stream);
            }
        }
        Object methodParameterBytes = MethodInternal.EMPTY_PARAMETER_NAMES;
        if (version >= 8 && (size = stream.readPackedU32()) > 0) {
            methodParameterBytes = new byte[size][];
            int i = 0;
            while (i < size) {
                methodParameterBytes[i] = this.byteTable[stream.readPackedU32()];
                ++i;
            }
        }
        MethodInfo methodInfo = new MethodInfo();
        AnnotationInstance[] annotations = this.readAnnotations(stream, methodInfo);
        MethodInternal methodInternal = new MethodInternal(name, (byte[][])methodParameterBytes, parameters, returnType, flags, receiverType, typeParameters, exceptions, annotations, defaultValue);
        methodInfo.setMethodInternal(methodInternal);
        return methodInternal;
    }

    private FieldInternal readFieldEntry(PackedDataInputStream stream) throws IOException {
        byte[] name = this.byteTable[stream.readPackedU32()];
        short flags = (short)stream.readPackedU32();
        Type type = this.typeTable[stream.readPackedU32()];
        FieldInfo fieldInfo = new FieldInfo();
        AnnotationInstance[] annotations = this.readAnnotations(stream, fieldInfo);
        FieldInternal fieldInternal = new FieldInternal(name, type, flags, annotations);
        fieldInfo.setFieldInternal(fieldInternal);
        return fieldInternal;
    }

    private ClassInfo readClassEntry(PackedDataInputStream stream, Map<DotName, List<AnnotationInstance>> masterAnnotations, int version) throws IOException {
        DotName name = this.nameTable[stream.readPackedU32()];
        short flags = (short)stream.readPackedU32();
        Type superType = this.typeTable[stream.readPackedU32()];
        Type[] typeParameters = this.typeListTable[stream.readPackedU32()];
        Type[] interfaceTypes = this.typeListTable[stream.readPackedU32()];
        boolean hasEnclosingMethod = false;
        boolean hasNesting = false;
        if (version >= 9) {
            int nestingMask = stream.readUnsignedByte();
            if (nestingMask > 0) {
                hasNesting = true;
                hasEnclosingMethod = (nestingMask & 2) == 2;
            }
        } else {
            hasNesting = true;
            hasEnclosingMethod = true;
        }
        DotName enclosingClass = null;
        ClassInfo.EnclosingMethodInfo enclosingMethod = null;
        String simpleName = null;
        if (hasNesting) {
            enclosingClass = this.nameTable[stream.readPackedU32()];
            simpleName = this.stringTable[stream.readPackedU32()];
            enclosingMethod = hasEnclosingMethod ? this.readEnclosingMethod(stream, version) : null;
        }
        int size = stream.readPackedU32();
        HashMap<DotName, List<AnnotationInstance>> annotations = new HashMap<DotName, List<AnnotationInstance>>(size);
        ClassInfo clazz = new ClassInfo(name, superType, flags, interfaceTypes, annotations);
        clazz.setTypeParameters(typeParameters);
        if (hasNesting) {
            clazz.setEnclosingMethod(enclosingMethod);
            clazz.setInnerClassInfo(enclosingClass, simpleName, version >= 9);
        }
        FieldInternal[] fields = this.readClassFields(stream, clazz);
        clazz.setFieldArray(fields);
        MethodInternal[] methods = this.readClassMethods(stream, clazz);
        clazz.setMethodArray(methods);
        int i = 0;
        while (i < size) {
            List<AnnotationInstance> instances = this.convertToList(this.readAnnotations(stream, clazz));
            if (instances.size() > 0) {
                DotName annotationName = instances.get(0).name();
                annotations.put(annotationName, instances);
                this.addToMaster(masterAnnotations, annotationName, instances);
            }
            ++i;
        }
        return clazz;
    }

    private void addToMaster(Map<DotName, List<AnnotationInstance>> masterAnnotations, DotName name, List<AnnotationInstance> annotations) {
        List<AnnotationInstance> entry = masterAnnotations.get(name);
        if (entry == null) {
            masterAnnotations.put(name, new ArrayList<AnnotationInstance>(annotations));
            return;
        }
        entry.addAll(annotations);
    }

    private List<AnnotationInstance> convertToList(AnnotationInstance[] annotationInstances) {
        if (annotationInstances.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(annotationInstances));
    }

    private void addClassToMap(HashMap<DotName, List<ClassInfo>> map, DotName name, ClassInfo currentClass) {
        List<ClassInfo> list = map.get(name);
        if (list == null) {
            list = new ArrayList<ClassInfo>();
            map.put(name, list);
        }
        list.add(currentClass);
    }

    private FieldInternal[] readClassFields(PackedDataInputStream stream, ClassInfo clazz) throws IOException {
        int len = stream.readPackedU32();
        FieldInternal[] fields = new FieldInternal[len];
        int i = 0;
        while (i < len) {
            FieldInternal field = this.fieldTable[stream.readPackedU32()];
            this.updateAnnotationTargetInfo(field.annotationArray(), clazz);
            fields[i] = field;
            ++i;
        }
        return fields;
    }

    private MethodInternal[] readClassMethods(PackedDataInputStream stream, ClassInfo clazz) throws IOException {
        int len = stream.readPackedU32();
        MethodInternal[] methods = new MethodInternal[len];
        int i = 0;
        while (i < len) {
            MethodInternal method = this.methodTable[stream.readPackedU32()];
            this.updateAnnotationTargetInfo(method.annotationArray(), clazz);
            methods[i] = method;
            if (method.parameterArray().length == 0 && Arrays.equals(INIT_METHOD_NAME, method.nameBytes())) {
                clazz.setHasNoArgsConstructor(true);
            }
            ++i;
        }
        return methods;
    }

    private void updateAnnotationTargetInfo(AnnotationInstance[] annotations, ClassInfo clazz) {
        AnnotationInstance[] annotationInstanceArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationInstance annotation = annotationInstanceArray[n2];
            AnnotationTarget target = annotation.target();
            if (target instanceof MethodInfo) {
                ((MethodInfo)target).setClassInfo(clazz);
            } else if (target instanceof MethodParameterInfo) {
                ((MethodParameterInfo)target).method().setClassInfo(clazz);
            } else if (target instanceof FieldInfo) {
                ((FieldInfo)target).setClassInfo(clazz);
            }
            ++n2;
        }
    }

    private ClassInfo.EnclosingMethodInfo readEnclosingMethod(PackedDataInputStream stream, int version) throws IOException {
        if (version < 9 && stream.readUnsignedByte() != 1) {
            return null;
        }
        String eName = this.stringTable[stream.readPackedU32()];
        DotName eClass = this.nameTable[stream.readPackedU32()];
        Type returnType = this.typeTable[stream.readPackedU32()];
        Type[] parameters = this.typeListTable[stream.readPackedU32()];
        return new ClassInfo.EnclosingMethodInfo(eName, returnType, parameters, eClass);
    }

    private Index readClasses(PackedDataInputStream stream, int annotationsSize, int implementorsSize, int subclassesSize, int version) throws IOException {
        int classesSize = stream.readPackedU32();
        HashMap<DotName, ClassInfo> classes = new HashMap<DotName, ClassInfo>(classesSize);
        HashMap<DotName, List<ClassInfo>> subclasses = new HashMap<DotName, List<ClassInfo>>(subclassesSize);
        HashMap<DotName, List<ClassInfo>> implementors = new HashMap<DotName, List<ClassInfo>>(implementorsSize);
        HashMap<DotName, List<AnnotationInstance>> masterAnnotations = new HashMap<DotName, List<AnnotationInstance>>(annotationsSize);
        int i = 0;
        while (i < classesSize) {
            ClassInfo clazz = this.readClassEntry(stream, masterAnnotations, version);
            this.addClassToMap(subclasses, clazz.superName(), clazz);
            Type[] typeArray = clazz.interfaceTypeArray();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type interfaceType = typeArray[n2];
                this.addClassToMap(implementors, interfaceType.name(), clazz);
                ++n2;
            }
            classes.put(clazz.name(), clazz);
            ++i;
        }
        return new Index(masterAnnotations, subclasses, implementors, classes);
    }

    @Override
    int toDataVersion(int version) {
        return 4;
    }
}

