/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.logging.JDKLoggerProvider;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logging.Slf4jLoggerProvider;

final class LoggerProviders {
    static final String LOGGING_PROVIDER_KEY = "org.jboss.logging.provider";
    static final LoggerProvider PROVIDER = LoggerProviders.find();

    private static LoggerProvider find() {
        return LoggerProviders.findProvider();
    }

    private static LoggerProvider findProvider() {
        ClassLoader cl = LoggerProviders.class.getClassLoader();
        try {
            String loggerProvider = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(LoggerProviders.LOGGING_PROVIDER_KEY);
                }
            });
            if (loggerProvider != null) {
                if ("jdk".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryJDK("system property");
                }
                if ("slf4j".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.trySlf4j("system property");
                }
            }
        }
        catch (Throwable throwable) {}
        try {
            ServiceLoader<LoggerProvider> loader = ServiceLoader.load(LoggerProvider.class, cl);
            Iterator<LoggerProvider> iter = loader.iterator();
            while (true) {
                try {
                    if (iter.hasNext()) {
                        LoggerProvider provider = iter.next();
                        LoggerProviders.logProvider(provider, "service loader");
                        return provider;
                    }
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {}
        try {
            Class.forName("ch.qos.logback.classic.Logger", false, cl);
            return LoggerProviders.trySlf4j(null);
        }
        catch (Throwable throwable) {
            return LoggerProviders.tryJDK(null);
        }
    }

    private static JDKLoggerProvider tryJDK(String via) {
        JDKLoggerProvider provider = new JDKLoggerProvider();
        LoggerProviders.logProvider(provider, via);
        return provider;
    }

    private static LoggerProvider trySlf4j(String via) {
        Slf4jLoggerProvider provider = new Slf4jLoggerProvider();
        LoggerProviders.logProvider(provider, via);
        return provider;
    }

    private static void logProvider(LoggerProvider provider, String via) {
        Logger logger = provider.getLogger(LoggerProviders.class.getPackage().getName());
        if (via == null) {
            logger.debugf("Logging Provider: %s", (Object)provider.getClass().getName());
        } else {
            logger.debugf("Logging Provider: %s found via %s", (Object)provider.getClass().getName(), (Object)via);
        }
    }

    private LoggerProviders() {
    }
}

