/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Iterator;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MessagePassingQueueUtil;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscCompoundQueueConsumerQueueIndex;
import org.jctools.util.PortableJvmInfo;

public class MpscCompoundQueue<E>
extends MpscCompoundQueueConsumerQueueIndex<E> {
    byte b000;
    byte b001;
    byte b002;
    byte b003;
    byte b004;
    byte b005;
    byte b006;
    byte b007;
    byte b010;
    byte b011;
    byte b012;
    byte b013;
    byte b014;
    byte b015;
    byte b016;
    byte b017;
    byte b020;
    byte b021;
    byte b022;
    byte b023;
    byte b024;
    byte b025;
    byte b026;
    byte b027;
    byte b030;
    byte b031;
    byte b032;
    byte b033;
    byte b034;
    byte b035;
    byte b036;
    byte b037;
    byte b040;
    byte b041;
    byte b042;
    byte b043;
    byte b044;
    byte b045;
    byte b046;
    byte b047;
    byte b050;
    byte b051;
    byte b052;
    byte b053;
    byte b054;
    byte b055;
    byte b056;
    byte b057;
    byte b060;
    byte b061;
    byte b062;
    byte b063;
    byte b064;
    byte b065;
    byte b066;
    byte b067;
    byte b070;
    byte b071;
    byte b072;
    byte b073;
    byte b074;
    byte b075;
    byte b076;
    byte b077;
    byte b100;
    byte b101;
    byte b102;
    byte b103;
    byte b104;
    byte b105;
    byte b106;
    byte b107;
    byte b110;
    byte b111;
    byte b112;
    byte b113;
    byte b114;
    byte b115;
    byte b116;
    byte b117;
    byte b120;
    byte b121;
    byte b122;
    byte b123;
    byte b124;
    byte b125;
    byte b126;
    byte b127;
    byte b130;
    byte b131;
    byte b132;
    byte b133;
    byte b134;
    byte b135;
    byte b136;
    byte b137;
    byte b140;
    byte b141;
    byte b142;
    byte b143;
    byte b144;
    byte b145;
    byte b146;
    byte b147;
    byte b150;
    byte b151;
    byte b152;
    byte b153;
    byte b154;
    byte b155;
    byte b156;
    byte b157;
    byte b160;
    byte b161;
    byte b162;
    byte b163;
    byte b164;
    byte b165;
    byte b166;
    byte b167;
    byte b170;
    byte b171;
    byte b172;
    byte b173;
    byte b174;
    byte b175;
    byte b176;
    byte b177;

    public MpscCompoundQueue(int capacity) {
        this(capacity, PortableJvmInfo.CPUs);
    }

    public MpscCompoundQueue(int capacity, int queueParallelism) {
        super(capacity, queueParallelism);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        if (queues[start].offer(e)) {
            return true;
        }
        return this.slowOffer(queues, parallelQueuesMask, start + 1, e);
    }

    private boolean slowOffer(MpscArrayQueue<E>[] queues, int parallelQueuesMask, int start, E e) {
        int status;
        int queueCount = parallelQueuesMask + 1;
        int end = start + queueCount;
        do {
            status = 0;
            int i = start;
            while (i < end) {
                int s = queues[i & parallelQueuesMask].failFastOffer(e);
                if (s == 0) {
                    return true;
                }
                status += s;
                ++i;
            }
        } while (status != queueCount);
        return false;
    }

    @Override
    public E poll() {
        int qIndex = this.consumerQueueIndex & this.parallelQueuesMask;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        while (qIndex < limit) {
            e = this.queues[qIndex & this.parallelQueuesMask].poll();
            if (e != null) break;
            ++qIndex;
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E peek() {
        int qIndex = this.consumerQueueIndex & this.parallelQueuesMask;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        while (qIndex < limit) {
            e = this.queues[qIndex & this.parallelQueuesMask].peek();
            if (e != null) break;
            ++qIndex;
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int size() {
        int size = 0;
        MpscArrayQueue[] mpscArrayQueueArray = this.queues;
        int n = this.queues.length;
        int n2 = 0;
        while (n2 < n) {
            MpscArrayQueue lane = mpscArrayQueueArray[n2];
            size += lane.size();
            ++n2;
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        if (queues[start].failFastOffer(e) == 0) {
            return true;
        }
        int i = start + 1;
        while (i < start + parallelQueuesMask + 1) {
            if (queues[i & parallelQueuesMask].failFastOffer(e) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public E relaxedPoll() {
        int qIndex = this.consumerQueueIndex & this.parallelQueuesMask;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        while (qIndex < limit) {
            e = this.queues[qIndex & this.parallelQueuesMask].relaxedPoll();
            if (e != null) break;
            ++qIndex;
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public E relaxedPeek() {
        int qIndex = this.consumerQueueIndex & this.parallelQueuesMask;
        int limit = qIndex + this.parallelQueues;
        E e = null;
        while (qIndex < limit) {
            e = this.queues[qIndex & this.parallelQueuesMask].relaxedPeek();
            if (e != null) break;
            ++qIndex;
        }
        this.consumerQueueIndex = qIndex;
        return e;
    }

    @Override
    public int capacity() {
        return this.queues.length * this.queues[0].capacity();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int limit = this.capacity();
        return this.drain(c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return MessagePassingQueueUtil.fillBounded(this, s);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        int parallelQueuesMask = this.parallelQueuesMask;
        MpscArrayQueue[] queues = this.queues;
        int start = (int)(Thread.currentThread().getId() & (long)parallelQueuesMask);
        int filled = queues[start].fill(s, limit);
        if (filled == limit) {
            return limit;
        }
        int i = start + 1;
        while (i < start + parallelQueuesMask + 1) {
            if ((filled += queues[i & parallelQueuesMask].fill(s, limit - filled)) == limit) {
                return limit;
            }
            ++i;
        }
        return filled;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, wait, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s, wait, exit);
    }
}

