/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.util.EnumSet;
import java.util.Set;

public enum DialectVersion {
    SMB1,
    SMB202(514),
    SMB210(528),
    SMB300(768),
    SMB302(770),
    SMB311(785);

    private final boolean smb2;
    private final int dialect;

    private DialectVersion() {
        this.smb2 = false;
        this.dialect = -1;
    }

    private DialectVersion(int dialectId) {
        this.smb2 = true;
        this.dialect = dialectId;
    }

    public final boolean isSMB2() {
        return this.smb2;
    }

    public final int getDialect() {
        if (!this.smb2) {
            throw new UnsupportedOperationException();
        }
        return this.dialect;
    }

    public boolean atLeast(DialectVersion v) {
        return this.ordinal() >= v.ordinal();
    }

    public boolean atMost(DialectVersion v) {
        return this.ordinal() <= v.ordinal();
    }

    public static DialectVersion min(DialectVersion a, DialectVersion b) {
        if (a.atMost(b)) {
            return a;
        }
        return b;
    }

    public static DialectVersion max(DialectVersion a, DialectVersion b) {
        if (a.atLeast(b)) {
            return a;
        }
        return b;
    }

    public static Set<DialectVersion> range(DialectVersion min, DialectVersion max) {
        EnumSet<DialectVersion> vers = EnumSet.noneOf(DialectVersion.class);
        DialectVersion[] dialectVersionArray = DialectVersion.values();
        int n = dialectVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DialectVersion ver = dialectVersionArray[n2];
            if ((min == null || ver.atLeast(min)) && (max == null || ver.atMost(max))) {
                vers.add(ver);
            }
            ++n2;
        }
        return vers;
    }
}

