/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.UUID;
import jcifs.dcerpc.msrpc.lsarpc;
import jcifs.dcerpc.msrpc.netdfs;
import jcifs.dcerpc.msrpc.samr;
import jcifs.dcerpc.msrpc.srvsvc;

public class DcerpcBinding {
    private static final Map<String, String> INTERFACES = new HashMap<String, String>();
    private String proto;
    private Map<String, Object> options = null;
    private String server;
    private String endpoint = null;
    private UUID uuid = null;
    private int major;
    private int minor;

    static {
        INTERFACES.put("srvsvc", srvsvc.getSyntax());
        INTERFACES.put("lsarpc", lsarpc.getSyntax());
        INTERFACES.put("samr", samr.getSyntax());
        INTERFACES.put("netdfs", netdfs.getSyntax());
        INTERFACES.put("netlogon", "12345678-1234-abcd-ef00-01234567cffb:1.0");
        INTERFACES.put("wkssvc", "6BFFD098-A112-3610-9833-46C3F87E345A:1.0");
        INTERFACES.put("samr", "12345778-1234-ABCD-EF00-0123456789AC:1.0");
    }

    public static void addInterface(String name, String syntax) {
        INTERFACES.put(name, syntax);
    }

    DcerpcBinding(String proto, String server) {
        this.proto = proto;
        this.server = server;
    }

    public String getProto() {
        return this.proto;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String getServer() {
        return this.server;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    UUID getUuid() {
        return this.uuid;
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    void setOption(String key, Object val) throws DcerpcException {
        if (key.equals("endpoint")) {
            String iface;
            this.endpoint = val.toString();
            String lep = this.endpoint.toLowerCase(Locale.ENGLISH);
            if (lep.startsWith("\\pipe\\") && (iface = INTERFACES.get(lep.substring(6))) != null) {
                int c = iface.indexOf(58);
                int p = iface.indexOf(46, c + 1);
                this.uuid = new UUID(iface.substring(0, c));
                this.major = Integer.parseInt(iface.substring(c + 1, p));
                this.minor = Integer.parseInt(iface.substring(p + 1));
                return;
            }
            throw new DcerpcException("Bad endpoint: " + this.endpoint);
        }
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(key, val);
    }

    Object getOption(String key) {
        if (key.equals("endpoint")) {
            return this.endpoint;
        }
        if (this.options != null) {
            return this.options.get(key);
        }
        return null;
    }

    public String toString() {
        String ret = String.valueOf(this.proto) + ":" + this.server + "[" + this.endpoint;
        if (this.options != null) {
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                ret = String.valueOf(ret) + "," + entry.getKey() + "=" + entry.getValue();
            }
        }
        ret = String.valueOf(ret) + "]";
        return ret;
    }
}

