/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbPipeHandleInternal;
import jcifs.util.Encdec;

public class DcerpcPipeHandle
extends DcerpcHandle {
    static final int pipeFlags = 27198979;
    private SmbNamedPipe pipe;
    private SmbPipeHandleInternal handle;

    public DcerpcPipeHandle(String url, CIFSContext tc, boolean unshared) throws DcerpcException, MalformedURLException {
        super(tc, DcerpcHandle.parseBinding(url));
        this.pipe = new SmbNamedPipe(this.makePipeUrl(), 27198979, unshared, tc);
        this.handle = this.pipe.openPipe().unwrap(SmbPipeHandleInternal.class);
    }

    private String makePipeUrl() {
        String address;
        DcerpcBinding binding = this.getBinding();
        String url = "smb://" + binding.getServer() + "/IPC$/" + binding.getEndpoint().substring(6);
        String params = "";
        String server = (String)binding.getOption("server");
        if (server != null) {
            params = String.valueOf(params) + "&server=" + server;
        }
        if ((address = (String)binding.getOption("address")) != null) {
            params = String.valueOf(params) + "&address=" + address;
        }
        if (params.length() > 0) {
            url = String.valueOf(url) + "?" + params.substring(1);
        }
        return url;
    }

    @Override
    public CIFSContext getTransportContext() {
        return this.pipe.getContext();
    }

    @Override
    public String getServer() {
        return this.pipe.getLocator().getServer();
    }

    @Override
    public String getServerWithDfs() {
        return this.pipe.getLocator().getServerWithDfs();
    }

    @Override
    public byte[] getSessionKey() throws CIFSException {
        return this.handle.getSessionKey();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int doSendReceiveFragment(byte[] buf, int off, int length, byte[] inB) throws IOException {
        if (this.handle.isStale()) {
            throw new IOException("DCERPC pipe is no longer open");
        }
        have = this.handle.sendrecv(buf, off, length, inB, this.getMaxRecv());
        fraglen = Encdec.dec_uint16le(inB, 8);
        if (fraglen <= this.getMaxRecv()) ** GOTO lbl11
        throw new IOException("Unexpected fragment length: " + fraglen);
lbl-1000:
        // 1 sources

        {
            r = this.handle.recv(inB, have, fraglen - have);
            if (r == 0) {
                throw new IOException("Unexpected EOF");
            }
            have += r;
lbl11:
            // 2 sources

            ** while (have < fraglen)
        }
lbl12:
        // 1 sources

        return have;
    }

    @Override
    protected void doSendFragment(byte[] buf, int off, int length) throws IOException {
        if (this.handle.isStale()) {
            throw new IOException("DCERPC pipe is no longer open");
        }
        this.handle.send(buf, off, length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int doReceiveFragment(byte[] buf) throws IOException {
        if (buf.length < this.getMaxRecv()) {
            throw new IllegalArgumentException("buffer too small");
        }
        off = this.handle.recv(buf, 0, buf.length);
        if (buf[0] != 5 || buf[1] != 0) {
            throw new IOException("Unexpected DCERPC PDU header");
        }
        length = Encdec.dec_uint16le(buf, 8);
        if (length <= this.getMaxRecv()) ** GOTO lbl13
        throw new IOException("Unexpected fragment length: " + length);
lbl-1000:
        // 1 sources

        {
            r = this.handle.recv(buf, off, length - off);
            if (r == 0) {
                throw new IOException("Unexpected EOF");
            }
            off += r;
lbl13:
            // 2 sources

            ** while (off < length)
        }
lbl14:
        // 1 sources

        return off;
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.handle.close();
        }
        finally {
            this.pipe.close();
        }
    }
}

