/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.dfs;

import java.util.Arrays;
import jcifs.Decodable;
import jcifs.internal.dfs.Referral;
import jcifs.internal.util.SMBUtil;

public class DfsReferralResponseBuffer
implements Decodable {
    private int pathConsumed;
    private int numReferrals;
    private int tflags;
    private Referral[] referrals;

    public final int getPathConsumed() {
        return this.pathConsumed;
    }

    public final int getNumReferrals() {
        return this.numReferrals;
    }

    public final int getTflags() {
        return this.tflags;
    }

    public final Referral[] getReferrals() {
        return this.referrals;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.pathConsumed = SMBUtil.readInt2(buffer, bufferIndex) / 2;
        this.numReferrals = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.tflags = SMBUtil.readInt2(buffer, bufferIndex += 2);
        bufferIndex += 4;
        this.referrals = new Referral[this.numReferrals];
        int ri = 0;
        while (ri < this.numReferrals) {
            this.referrals[ri] = new Referral();
            bufferIndex += this.referrals[ri].decode(buffer, bufferIndex, len);
            ++ri;
        }
        return bufferIndex - start;
    }

    public String toString() {
        return "pathConsumed=" + this.pathConsumed + ",numReferrals=" + this.numReferrals + ",flags=" + this.tflags + ",referrals=" + Arrays.toString(this.referrals);
    }
}

