/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.dfs;

import java.util.ArrayList;
import jcifs.Decodable;
import jcifs.RuntimeCIFSException;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Strings;

public class Referral
implements Decodable {
    int version;
    int size;
    int serverType;
    int rflags;
    int proximity;
    String altPath;
    int ttl;
    String rpath = null;
    String node = null;
    String specialName = null;
    String[] expandedNames = new String[0];

    public final int getVersion() {
        return this.version;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getServerType() {
        return this.serverType;
    }

    public final int getRFlags() {
        return this.rflags;
    }

    public final int getProximity() {
        return this.proximity;
    }

    public final String getAltPath() {
        return this.altPath;
    }

    public final int getTtl() {
        return this.ttl;
    }

    public final String getRpath() {
        return this.rpath;
    }

    public final String getNode() {
        return this.node;
    }

    public final String getSpecialName() {
        return this.specialName;
    }

    public final String[] getExpandedNames() {
        return this.expandedNames;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.version = SMBUtil.readInt2(buffer, bufferIndex);
        if (this.version != 3 && this.version != 1) {
            throw new RuntimeCIFSException("Version " + this.version + " referral not supported. Please report this to jcifs at samba dot org.");
        }
        this.size = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.serverType = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.rflags = SMBUtil.readInt2(buffer, bufferIndex += 2);
        bufferIndex += 2;
        if (this.version == 3) {
            this.proximity = SMBUtil.readInt2(buffer, bufferIndex);
            this.ttl = SMBUtil.readInt2(buffer, bufferIndex += 2);
            bufferIndex += 2;
            if ((this.rflags & 2) == 0) {
                int pathOffset = SMBUtil.readInt2(buffer, bufferIndex);
                int altPathOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
                int nodeOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
                bufferIndex += 2;
                if (pathOffset > 0) {
                    this.rpath = Referral.readString(buffer, start + pathOffset, len);
                }
                if (nodeOffset > 0) {
                    this.node = Referral.readString(buffer, start + nodeOffset, len);
                }
                if (altPathOffset > 0) {
                    this.altPath = Referral.readString(buffer, start + altPathOffset, len);
                }
            } else {
                int specialNameOffset = SMBUtil.readInt2(buffer, bufferIndex);
                int numExpanded = SMBUtil.readInt2(buffer, bufferIndex += 2);
                int expandedNameOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
                bufferIndex += 2;
                if (specialNameOffset > 0) {
                    this.specialName = Referral.readString(buffer, start + specialNameOffset, len);
                }
                if (expandedNameOffset > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    int i = 0;
                    while (i < numExpanded) {
                        String en = Referral.readString(buffer, start + expandedNameOffset, len);
                        names.add(en);
                        expandedNameOffset += en.length() * 2 + 2;
                        ++i;
                    }
                    this.expandedNames = names.toArray(new String[names.size()]);
                }
            }
        } else if (this.version == 1) {
            this.node = Referral.readString(buffer, bufferIndex, len);
        }
        return this.size;
    }

    private static String readString(byte[] buffer, int bufferIndex, int len) {
        if (bufferIndex % 2 != 0) {
            ++bufferIndex;
        }
        return Strings.fromUNIBytes(buffer, bufferIndex, Strings.findUNITermination(buffer, bufferIndex, len));
    }

    public String toString() {
        return new String("Referral[version=" + this.version + ",size=" + this.size + ",serverType=" + this.serverType + ",flags=" + this.rflags + ",proximity=" + this.proximity + ",ttl=" + this.ttl + ",path=" + this.rpath + ",altPath=" + this.altPath + ",node=" + this.node + "]");
    }
}

