/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb1.AndXServerMessageBlock;
import jcifs.internal.smb1.com.LockingAndXRange;
import jcifs.internal.util.SMBUtil;

public class SmbComLockingAndX
extends AndXServerMessageBlock {
    private int fid;
    private byte typeOfLock;
    private byte newOpLockLevel;
    private long timeout;
    private LockingAndXRange[] locks;
    private LockingAndXRange[] unlocks;
    private boolean largeFile;

    public SmbComLockingAndX(Configuration config) {
        super(config);
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        dst[dstIndex += 2] = this.typeOfLock;
        dst[dstIndex + 1] = this.newOpLockLevel;
        SMBUtil.writeInt4(this.timeout, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.unlocks != null ? this.unlocks.length : 0, dst, dstIndex += 4);
        SMBUtil.writeInt2(this.locks != null ? this.locks.length : 0, dst, dstIndex += 2);
        return start - (dstIndex += 2);
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.fid = SMBUtil.readInt2(buffer, bufferIndex);
        this.typeOfLock = buffer[bufferIndex += 2];
        if ((this.typeOfLock & 0x10) == 16) {
            this.largeFile = true;
        }
        this.newOpLockLevel = buffer[bufferIndex + 1];
        this.timeout = SMBUtil.readInt4(buffer, bufferIndex += 2);
        int nunlocks = SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.unlocks = new LockingAndXRange[nunlocks];
        int nlocks = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.locks = new LockingAndXRange[nlocks];
        return start - (bufferIndex += 2);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        LockingAndXRange lockingAndXRange;
        int n;
        int n2;
        LockingAndXRange[] lockingAndXRangeArray;
        int start = dstIndex;
        if (this.unlocks != null) {
            lockingAndXRangeArray = this.unlocks;
            n2 = this.unlocks.length;
            n = 0;
            while (n < n2) {
                lockingAndXRange = lockingAndXRangeArray[n];
                dstIndex += lockingAndXRange.encode(dst, dstIndex);
                ++n;
            }
        }
        if (this.locks != null) {
            lockingAndXRangeArray = this.locks;
            n2 = this.locks.length;
            n = 0;
            while (n < n2) {
                lockingAndXRange = lockingAndXRangeArray[n];
                dstIndex += lockingAndXRange.encode(dst, dstIndex);
                ++n;
            }
        }
        return start - dstIndex;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int i = 0;
        while (i < this.unlocks.length) {
            this.unlocks[i] = this.createLockRange();
            bufferIndex += this.unlocks[i].decode(buffer, bufferIndex, buffer.length);
            ++i;
        }
        i = 0;
        while (i < this.locks.length) {
            this.locks[i] = this.createLockRange();
            bufferIndex += this.locks[i].decode(buffer, bufferIndex, buffer.length);
            ++i;
        }
        return start - bufferIndex;
    }

    private LockingAndXRange createLockRange() {
        return new LockingAndXRange(this.largeFile);
    }

    @Override
    public String toString() {
        return new String("SmbComLockingAndX[" + super.toString() + ",fid=" + this.fid + ",typeOfLock=" + this.typeOfLock + ",newOplockLevel=" + this.newOpLockLevel + "]");
    }
}

