/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans;

import java.util.Enumeration;
import jcifs.Configuration;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public abstract class SmbComTransaction
extends ServerMessageBlock
implements Enumeration<SmbComTransaction> {
    private static final int PRIMARY_SETUP_OFFSET = 61;
    private static final int SECONDARY_PARAMETER_OFFSET = 51;
    static final int DISCONNECT_TID = 1;
    static final int ONE_WAY_TRANSACTION = 2;
    static final int PADDING_SIZE = 4;
    private int tflags = 0;
    private int pad1 = 0;
    private int pad2 = 0;
    private boolean hasMore = true;
    private boolean isPrimary = true;
    private int bufParameterOffset;
    private int bufDataOffset;
    static final int TRANSACTION_BUF_SIZE = 65535;
    public static final byte TRANS2_FIND_FIRST2 = 1;
    public static final byte TRANS2_FIND_NEXT2 = 2;
    public static final byte TRANS2_QUERY_FS_INFORMATION = 3;
    public static final byte TRANS2_QUERY_PATH_INFORMATION = 5;
    public static final byte TRANS2_GET_DFS_REFERRAL = 16;
    public static final byte TRANS2_QUERY_FILE_INFORMATION = 7;
    public static final byte TRANS2_SET_FILE_INFORMATION = 8;
    public static final byte NET_SHARE_ENUM = 0;
    public static final byte NET_SERVER_ENUM2 = 104;
    public static final byte NET_SERVER_ENUM3 = -41;
    public static final byte TRANS_PEEK_NAMED_PIPE = 35;
    public static final byte TRANS_WAIT_NAMED_PIPE = 83;
    public static final byte TRANS_CALL_NAMED_PIPE = 84;
    public static final byte TRANS_TRANSACT_NAMED_PIPE = 38;
    protected int primarySetupOffset;
    protected int secondaryParameterOffset;
    protected int parameterCount;
    protected int parameterOffset;
    protected int parameterDisplacement;
    protected int dataCount;
    protected int dataOffset;
    protected int dataDisplacement;
    protected int totalParameterCount;
    protected int totalDataCount;
    protected int maxParameterCount;
    protected int maxDataCount;
    protected byte maxSetupCount;
    protected int timeout = 0;
    protected int setupCount = 1;
    private byte subCommand;
    protected String name = "";
    protected int maxBufferSize;
    private byte[] txn_buf;

    protected SmbComTransaction(Configuration config, byte command, byte subCommand) {
        super(config, command);
        this.subCommand = subCommand;
        this.maxDataCount = config.getTransactionBufferSize() - 512;
        this.maxParameterCount = 1024;
        this.primarySetupOffset = 61;
        this.secondaryParameterOffset = 51;
    }

    public final void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public final void setMaxDataCount(int maxDataCount) {
        this.maxDataCount = maxDataCount;
    }

    public void setBuffer(byte[] buffer) {
        this.txn_buf = buffer;
    }

    public byte[] releaseBuffer() {
        byte[] buf = this.txn_buf;
        this.txn_buf = null;
        return buf;
    }

    public final byte getSubCommand() {
        return this.subCommand;
    }

    public final void setSubCommand(byte subCommand) {
        this.subCommand = subCommand;
    }

    @Override
    public void reset() {
        super.reset();
        this.hasMore = true;
        this.isPrimary = true;
    }

    protected void reset(int key, String lastName) {
        this.reset();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public SmbComTransaction nextElement() {
        if (this.isPrimary) {
            this.isPrimary = false;
            this.parameterOffset = this.primarySetupOffset;
            this.parameterOffset += this.setupCount * 2;
            this.parameterOffset += 2;
            if (this.getCommand() == 37 && !this.isResponse()) {
                this.parameterOffset += this.stringWireLength(this.name, this.parameterOffset);
            }
            this.pad1 = this.pad(this.parameterOffset);
            this.parameterOffset += this.pad1;
            this.bufDataOffset = this.totalParameterCount = this.writeParametersWireFormat(this.txn_buf, this.bufParameterOffset);
            int available = this.maxBufferSize - this.parameterOffset;
            this.parameterCount = Math.min(this.totalParameterCount, available);
            this.dataOffset = this.parameterOffset + this.parameterCount;
            this.pad2 = this.pad(this.dataOffset);
            this.dataOffset += this.pad2;
            this.totalDataCount = this.writeDataWireFormat(this.txn_buf, this.bufDataOffset);
            this.dataCount = Math.min(this.totalDataCount, available -= this.parameterCount);
        } else {
            if (this.getCommand() != -96) {
                this.setCommand(38);
            } else {
                this.setCommand(-95);
            }
            this.parameterOffset = 51;
            if (this.totalParameterCount - this.parameterDisplacement > 0) {
                this.pad1 = this.pad(this.parameterOffset);
                this.parameterOffset += this.pad1;
            }
            this.parameterDisplacement += this.parameterCount;
            int available = this.maxBufferSize - this.parameterOffset - this.pad1;
            this.parameterCount = Math.min(this.totalParameterCount - this.parameterDisplacement, available);
            available -= this.parameterCount;
            this.dataOffset = this.parameterOffset + this.parameterCount;
            this.pad2 = this.pad(this.dataOffset);
            this.dataOffset += this.pad2;
            this.dataDisplacement += this.dataCount;
            this.dataCount = Math.min(this.totalDataCount - this.dataDisplacement, available -= this.pad2);
        }
        if (this.parameterDisplacement + this.parameterCount >= this.totalParameterCount && this.dataDisplacement + this.dataCount >= this.totalDataCount) {
            this.hasMore = false;
        }
        return this;
    }

    protected int pad(int offset) {
        int p = offset % this.getPadding();
        if (p == 0) {
            return 0;
        }
        return this.getPadding() - p;
    }

    public int getPadding() {
        return 4;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.totalParameterCount, dst, dstIndex);
        SMBUtil.writeInt2(this.totalDataCount, dst, dstIndex += 2);
        dstIndex += 2;
        if (this.getCommand() != 38) {
            SMBUtil.writeInt2(this.maxParameterCount, dst, dstIndex);
            SMBUtil.writeInt2(this.maxDataCount, dst, dstIndex += 2);
            dstIndex += 2;
            dst[dstIndex++] = this.maxSetupCount;
            dst[dstIndex++] = 0;
            SMBUtil.writeInt2(this.tflags, dst, dstIndex);
            SMBUtil.writeInt4(this.timeout, dst, dstIndex += 2);
            dstIndex += 4;
            dst[dstIndex++] = 0;
            dst[dstIndex++] = 0;
        }
        SMBUtil.writeInt2(this.parameterCount, dst, dstIndex);
        SMBUtil.writeInt2(this.parameterOffset, dst, dstIndex += 2);
        dstIndex += 2;
        if (this.getCommand() == 38) {
            SMBUtil.writeInt2(this.parameterDisplacement, dst, dstIndex);
            dstIndex += 2;
        }
        SMBUtil.writeInt2(this.dataCount, dst, dstIndex);
        SMBUtil.writeInt2(this.dataCount == 0 ? 0 : this.dataOffset, dst, dstIndex += 2);
        dstIndex += 2;
        if (this.getCommand() == 38) {
            SMBUtil.writeInt2(this.dataDisplacement, dst, dstIndex);
            dstIndex += 2;
        } else {
            dst[dstIndex++] = (byte)this.setupCount;
            dst[dstIndex++] = 0;
            dstIndex += this.writeSetupWireFormat(dst, dstIndex);
        }
        return dstIndex - start;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.getCommand() == 37 && !this.isResponse()) {
            dstIndex += this.writeString(this.name, dst, dstIndex);
        }
        int end = dstIndex + this.pad1;
        if (this.parameterCount > 0) {
            System.arraycopy(this.txn_buf, this.bufParameterOffset, dst, this.headerStart + this.parameterOffset, this.parameterCount);
            end = Math.max(end, this.headerStart + this.parameterOffset + this.parameterCount + this.pad2);
        }
        if (this.dataCount > 0) {
            System.arraycopy(this.txn_buf, this.bufDataOffset, dst, this.headerStart + this.dataOffset, this.dataCount);
            this.bufDataOffset += this.dataCount;
            end = Math.max(end, this.headerStart + this.dataOffset + this.dataCount);
        }
        return end - start;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    protected abstract int writeSetupWireFormat(byte[] var1, int var2);

    protected abstract int writeParametersWireFormat(byte[] var1, int var2);

    protected abstract int writeDataWireFormat(byte[] var1, int var2);

    protected abstract int readSetupWireFormat(byte[] var1, int var2, int var3);

    protected abstract int readParametersWireFormat(byte[] var1, int var2, int var3);

    protected abstract int readDataWireFormat(byte[] var1, int var2, int var3);

    @Override
    public String toString() {
        return new String(String.valueOf(super.toString()) + ",totalParameterCount=" + this.totalParameterCount + ",totalDataCount=" + this.totalDataCount + ",maxParameterCount=" + this.maxParameterCount + ",maxDataCount=" + this.maxDataCount + ",maxSetupCount=" + this.maxSetupCount + ",flags=0x" + Hexdump.toHexString(this.tflags, 2) + ",timeout=" + this.timeout + ",parameterCount=" + this.parameterCount + ",parameterOffset=" + this.parameterOffset + ",parameterDisplacement=" + this.parameterDisplacement + ",dataCount=" + this.dataCount + ",dataOffset=" + this.dataOffset + ",dataDisplacement=" + this.dataDisplacement + ",setupCount=" + this.setupCount + ",pad=" + this.pad1 + ",pad1=" + this.pad2);
    }
}

