/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans;

import java.util.Enumeration;
import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.FileEntry;

public abstract class SmbComTransactionResponse
extends ServerMessageBlock
implements Enumeration<SmbComTransactionResponse> {
    static final int SETUP_OFFSET = 61;
    static final int DISCONNECT_TID = 1;
    static final int ONE_WAY_TRANSACTION = 2;
    private int pad;
    private int pad1;
    private boolean parametersDone;
    private boolean dataDone;
    protected int totalParameterCount;
    protected int totalDataCount;
    protected int parameterCount;
    protected int parameterOffset;
    protected int parameterDisplacement;
    protected int dataOffset;
    protected int dataDisplacement;
    protected int setupCount;
    protected int bufParameterStart;
    protected int bufDataStart;
    int dataCount;
    byte subCommand;
    volatile boolean hasMore = true;
    volatile boolean isPrimary = true;
    byte[] txn_buf;
    private int status;
    private int numEntries;
    private FileEntry[] results;

    protected SmbComTransactionResponse(Configuration config) {
        super(config);
    }

    protected SmbComTransactionResponse(Configuration config, byte command, byte subcommand) {
        super(config, command);
        this.subCommand = subcommand;
    }

    protected final int getDataCount() {
        return this.dataCount;
    }

    public final void setDataCount(int dataCount) {
        this.dataCount = dataCount;
    }

    public void setBuffer(byte[] buffer) {
        this.txn_buf = buffer;
    }

    public byte[] releaseBuffer() {
        byte[] buf = this.txn_buf;
        this.txn_buf = null;
        return buf;
    }

    public final byte getSubCommand() {
        return this.subCommand;
    }

    public final void setSubCommand(byte subCommand) {
        this.subCommand = subCommand;
    }

    public final int getStatus() {
        return this.status;
    }

    protected final void setStatus(int status) {
        this.status = status;
    }

    public final int getNumEntries() {
        return this.numEntries;
    }

    protected final void setNumEntries(int numEntries) {
        this.numEntries = numEntries;
    }

    public final FileEntry[] getResults() {
        return this.results;
    }

    protected final void setResults(FileEntry[] results) {
        this.results = results;
    }

    @Override
    public void reset() {
        super.reset();
        this.bufDataStart = 0;
        this.hasMore = true;
        this.isPrimary = true;
        this.dataDone = false;
        this.parametersDone = false;
    }

    @Override
    public boolean hasMoreElements() {
        return this.errorCode == 0 && this.hasMore;
    }

    @Override
    public SmbComTransactionResponse nextElement() {
        if (this.isPrimary) {
            this.isPrimary = false;
        }
        return this;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int len = super.decode(buffer, bufferIndex);
        if (this.byteCount == 0) {
            this.readBytesWireFormat(buffer, len + bufferIndex);
        }
        this.nextElement();
        return len;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.totalParameterCount = SMBUtil.readInt2(buffer, bufferIndex);
        if (this.bufDataStart == 0) {
            this.bufDataStart = this.totalParameterCount;
        }
        this.totalDataCount = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.parameterCount = SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.parameterOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.parameterDisplacement = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.dataCount = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.dataOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.dataDisplacement = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.setupCount = buffer[bufferIndex += 2] & 0xFF;
        return (bufferIndex += 2) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        this.pad1 = 0;
        this.pad = 0;
        if (this.parameterCount > 0) {
            this.pad = this.parameterOffset - (bufferIndex - this.headerStart);
            System.arraycopy(buffer, bufferIndex += this.pad, this.txn_buf, this.bufParameterStart + this.parameterDisplacement, this.parameterCount);
            bufferIndex += this.parameterCount;
        }
        if (this.dataCount > 0) {
            this.pad1 = this.dataOffset - (bufferIndex - this.headerStart);
            System.arraycopy(buffer, bufferIndex += this.pad1, this.txn_buf, this.bufDataStart + this.dataDisplacement, this.dataCount);
            bufferIndex += this.dataCount;
        }
        if (!this.parametersDone && this.parameterDisplacement + this.parameterCount == this.totalParameterCount) {
            this.parametersDone = true;
        }
        if (!this.dataDone && this.dataDisplacement + this.dataCount == this.totalDataCount) {
            this.dataDone = true;
        }
        if (this.parametersDone && this.dataDone) {
            this.readParametersWireFormat(this.txn_buf, this.bufParameterStart, this.totalParameterCount);
            this.readDataWireFormat(this.txn_buf, this.bufDataStart, this.totalDataCount);
            this.hasMore = false;
        }
        return this.pad + this.parameterCount + this.pad1 + this.dataCount;
    }

    protected abstract int writeSetupWireFormat(byte[] var1, int var2);

    protected abstract int writeParametersWireFormat(byte[] var1, int var2);

    protected abstract int writeDataWireFormat(byte[] var1, int var2);

    protected abstract int readSetupWireFormat(byte[] var1, int var2, int var3);

    protected abstract int readParametersWireFormat(byte[] var1, int var2, int var3) throws SMBProtocolDecodingException;

    protected abstract int readDataWireFormat(byte[] var1, int var2, int var3) throws SMBProtocolDecodingException;

    @Override
    public String toString() {
        return new String(String.valueOf(super.toString()) + ",totalParameterCount=" + this.totalParameterCount + ",totalDataCount=" + this.totalDataCount + ",parameterCount=" + this.parameterCount + ",parameterOffset=" + this.parameterOffset + ",parameterDisplacement=" + this.parameterDisplacement + ",dataCount=" + this.dataCount + ",dataOffset=" + this.dataOffset + ",dataDisplacement=" + this.dataDisplacement + ",setupCount=" + this.setupCount + ",pad=" + this.pad + ",pad1=" + this.pad1);
    }
}

