/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans2;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.fscc.FileBothDirectoryInfo;
import jcifs.internal.smb1.trans.SmbComTransactionResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.FileEntry;

public class Trans2FindFirst2Response
extends SmbComTransactionResponse {
    static final int SMB_INFO_STANDARD = 1;
    static final int SMB_INFO_QUERY_EA_SIZE = 2;
    static final int SMB_INFO_QUERY_EAS_FROM_LIST = 3;
    static final int SMB_FIND_FILE_DIRECTORY_INFO = 257;
    static final int SMB_FIND_FILE_FULL_DIRECTORY_INFO = 258;
    static final int SMB_FILE_NAMES_INFO = 259;
    static final int SMB_FILE_BOTH_DIRECTORY_INFO = 260;
    private int sid;
    private boolean isEndOfSearch;
    private int eaErrorOffset;
    private int lastNameOffset;
    private int lastNameBufferIndex;
    private String lastName;
    private int resumeKey;

    public Trans2FindFirst2Response(Configuration config) {
        super(config, (byte)50, (byte)1);
    }

    public final int getSid() {
        return this.sid;
    }

    public final boolean isEndOfSearch() {
        return this.isEndOfSearch;
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final int getResumeKey() {
        return this.resumeKey;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        if (this.getSubCommand() == 1) {
            this.sid = SMBUtil.readInt2(buffer, bufferIndex);
            bufferIndex += 2;
        }
        this.setNumEntries(SMBUtil.readInt2(buffer, bufferIndex));
        this.isEndOfSearch = (buffer[bufferIndex += 2] & 1) == 1;
        this.eaErrorOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.lastNameOffset = SMBUtil.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 2) - start;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        this.lastNameBufferIndex = bufferIndex + this.lastNameOffset;
        FileEntry[] results = new FileBothDirectoryInfo[this.getNumEntries()];
        int i = 0;
        while (i < this.getNumEntries()) {
            FileBothDirectoryInfo e = new FileBothDirectoryInfo(this.getConfig(), this.isUseUnicode());
            results[i] = e;
            e.decode(buffer, bufferIndex, len);
            if (this.lastNameBufferIndex >= bufferIndex && (e.getNextEntryOffset() == 0 || this.lastNameBufferIndex < bufferIndex + e.getNextEntryOffset())) {
                this.lastName = e.getFilename();
                this.resumeKey = e.getFileIndex();
            }
            bufferIndex += e.getNextEntryOffset();
            ++i;
        }
        this.setResults(results);
        return this.getDataCount();
    }

    @Override
    public String toString() {
        String c = this.getSubCommand() == 1 ? "Trans2FindFirst2Response[" : "Trans2FindNext2Response[";
        return new String(String.valueOf(c) + super.toString() + ",sid=" + this.sid + ",searchCount=" + this.getNumEntries() + ",isEndOfSearch=" + this.isEndOfSearch + ",eaErrorOffset=" + this.eaErrorOffset + ",lastNameOffset=" + this.lastNameOffset + ",lastName=" + this.lastName + "]");
    }
}

