/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.create;

import java.nio.charset.StandardCharsets;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.RequestWithPath;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.create.CreateContextRequest;
import jcifs.internal.smb2.create.Smb2CreateResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2CreateRequest
extends ServerMessageBlock2Request<Smb2CreateResponse>
implements RequestWithPath {
    private static final Logger log = LoggerFactory.getLogger(Smb2CreateRequest.class);
    public static final byte SMB2_OPLOCK_LEVEL_NONE = 0;
    public static final byte SMB2_OPLOCK_LEVEL_II = 1;
    public static final byte SMB2_OPLOCK_LEVEL_EXCLUSIVE = 8;
    public static final byte SMB2_OPLOCK_LEVEL_BATCH = 9;
    public static final byte SMB2_OPLOCK_LEVEL_LEASE = -1;
    public static final int SMB2_IMPERSONATION_LEVEL_ANONYMOUS = 0;
    public static final int SMB2_IMPERSONATION_LEVEL_IDENTIFICATION = 1;
    public static final int SMB2_IMPERSONATION_LEVEL_IMPERSONATION = 2;
    public static final int SMB2_IMPERSONATION_LEVEL_DELEGATE = 3;
    public static final int FILE_SHARE_READ = 1;
    public static final int FILE_SHARE_WRITE = 2;
    public static final int FILE_SHARE_DELETE = 4;
    public static final int FILE_SUPERSEDE = 0;
    public static final int FILE_OPEN = 1;
    public static final int FILE_CREATE = 2;
    public static final int FILE_OPEN_IF = 3;
    public static final int FILE_OVERWRITE = 4;
    public static final int FILE_OVERWRITE_IF = 5;
    public static final int FILE_DIRECTORY_FILE = 1;
    public static final int FILE_WRITE_THROUGH = 2;
    public static final int FILE_SEQUENTIAL_ONLY = 4;
    public static final int FILE_NO_IMTERMEDIATE_BUFFERING = 8;
    public static final int FILE_SYNCHRONOUS_IO_ALERT = 16;
    public static final int FILE_SYNCHRONOUS_IO_NONALERT = 32;
    public static final int FILE_NON_DIRECTORY_FILE = 64;
    public static final int FILE_COMPLETE_IF_OPLOCKED = 256;
    public static final int FILE_NO_EA_KNOWLEDGE = 512;
    public static final int FILE_OPEN_REMOTE_INSTANCE = 1024;
    public static final int FILE_RANDOM_ACCESS = 2048;
    public static final int FILE_DELETE_ON_CLOSE = 4096;
    public static final int FILE_OPEN_BY_FILE_ID = 8192;
    public static final int FILE_OPEN_FOR_BACKUP_INTENT = 16384;
    public static final int FILE_NO_COMPRESSION = 32768;
    public static final int FILE_OPEN_REQUIRING_OPLOCK = 65536;
    public static final int FILE_DISALLOW_EXCLUSIVE = 131072;
    public static final int FILE_RESERVE_OPFILTER = 0x100000;
    public static final int FILE_OPEN_REPARSE_POINT = 0x200000;
    public static final int FILE_NOP_RECALL = 0x400000;
    public static final int FILE_OPEN_FOR_FREE_SPACE_QUERY = 0x800000;
    private byte securityFlags;
    private byte requestedOplockLevel = 0;
    private int impersonationLevel = 2;
    private long smbCreateFlags;
    private int desiredAccess = 1179785;
    private int fileAttributes;
    private int shareAccess = 3;
    private int createDisposition = 1;
    private int createOptions = 0;
    private String name;
    private CreateContextRequest[] createContexts;
    private String fullName;
    private String domain;
    private String server;
    private boolean resolveDfs;

    public Smb2CreateRequest(Configuration config, String name) {
        super(config, 5);
        this.setPath(name);
    }

    @Override
    protected Smb2CreateResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2CreateResponse> req) {
        return new Smb2CreateResponse(tc.getConfig(), this.name);
    }

    @Override
    public String getPath() {
        return String.valueOf('\\') + this.name;
    }

    @Override
    public String getFullUNCPath() {
        return this.fullName;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setFullUNCPath(String domain, String server, String fullName) {
        this.domain = domain;
        this.server = server;
        this.fullName = fullName;
    }

    @Override
    public void setPath(String path) {
        if (path.length() > 0 && path.charAt(0) == '\\') {
            path = path.substring(1);
        }
        if (path.length() > 1 && path.charAt(path.length() - 1) == '\\') {
            path = path.substring(0, path.length() - 1);
        }
        this.name = path;
    }

    @Override
    public void setResolveInDfs(boolean resolve) {
        this.addFlags(0x10000000);
        this.resolveDfs = resolve;
    }

    @Override
    public boolean isResolveInDfs() {
        return this.resolveDfs;
    }

    public void setSecurityFlags(byte securityFlags) {
        this.securityFlags = securityFlags;
    }

    public void setRequestedOplockLevel(byte requestedOplockLevel) {
        this.requestedOplockLevel = requestedOplockLevel;
    }

    public void setImpersonationLevel(int impersonationLevel) {
        this.impersonationLevel = impersonationLevel;
    }

    public void setSmbCreateFlags(long smbCreateFlags) {
        this.smbCreateFlags = smbCreateFlags;
    }

    public void setDesiredAccess(int desiredAccess) {
        this.desiredAccess = desiredAccess;
    }

    public void setFileAttributes(int fileAttributes) {
        this.fileAttributes = fileAttributes;
    }

    public void setShareAccess(int shareAccess) {
        this.shareAccess = shareAccess;
    }

    public void setCreateDisposition(int createDisposition) {
        this.createDisposition = createDisposition;
    }

    public void setCreateOptions(int createOptions) {
        this.createOptions = createOptions;
    }

    @Override
    public int size() {
        int size = 120;
        int nameLen = 2 * this.name.length();
        if (nameLen == 0) {
            ++nameLen;
        }
        size += Smb2CreateRequest.size8(nameLen);
        if (this.createContexts != null) {
            CreateContextRequest[] createContextRequestArray = this.createContexts;
            int n = this.createContexts.length;
            int n2 = 0;
            while (n2 < n) {
                CreateContextRequest ccr = createContextRequestArray[n2];
                size += Smb2CreateRequest.size8(ccr.size());
                ++n2;
            }
        }
        return Smb2CreateRequest.size8(size);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (log.isDebugEnabled()) {
            log.debug("Opening " + this.name);
            log.debug("Flags are " + Hexdump.toHexString(this.getFlags(), 4));
        }
        SMBUtil.writeInt2(57L, dst, dstIndex);
        dst[dstIndex + 2] = this.securityFlags;
        dst[dstIndex + 3] = this.requestedOplockLevel;
        SMBUtil.writeInt4(this.impersonationLevel, dst, dstIndex += 4);
        SMBUtil.writeInt8(this.smbCreateFlags, dst, dstIndex += 4);
        dstIndex += 8;
        SMBUtil.writeInt4(this.desiredAccess, dst, dstIndex += 8);
        SMBUtil.writeInt4(this.fileAttributes, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.shareAccess, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.createDisposition, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.createOptions, dst, dstIndex += 4);
        int nameOffsetOffset = dstIndex += 4;
        byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_16LE);
        SMBUtil.writeInt2(nameBytes.length, dst, dstIndex + 2);
        int createContextOffsetOffset = dstIndex += 4;
        int createContextLengthOffset = dstIndex += 4;
        SMBUtil.writeInt2((dstIndex += 4) - this.getHeaderStart(), dst, nameOffsetOffset);
        System.arraycopy(nameBytes, 0, dst, dstIndex, nameBytes.length);
        dstIndex = nameBytes.length == 0 ? ++dstIndex : (dstIndex += nameBytes.length);
        dstIndex += this.pad8(dstIndex);
        if (this.createContexts == null || this.createContexts.length == 0) {
            SMBUtil.writeInt4(0L, dst, createContextOffsetOffset);
        } else {
            SMBUtil.writeInt4(dstIndex - this.getHeaderStart(), dst, createContextOffsetOffset);
        }
        int totalCreateContextLength = 0;
        if (this.createContexts != null) {
            int lastStart = -1;
            CreateContextRequest[] createContextRequestArray = this.createContexts;
            int n = this.createContexts.length;
            int n2 = 0;
            while (n2 < n) {
                CreateContextRequest createContext = createContextRequestArray[n2];
                int structStart = dstIndex;
                SMBUtil.writeInt4(0L, dst, structStart);
                if (lastStart > 0) {
                    SMBUtil.writeInt4(structStart - dstIndex, dst, lastStart);
                }
                byte[] cnBytes = createContext.getName();
                int cnOffsetOffset = dstIndex += 4;
                SMBUtil.writeInt2(cnBytes.length, dst, dstIndex + 2);
                int dataOffsetOffset = (dstIndex += 4) + 2;
                int dataLengthOffset = dstIndex += 4;
                SMBUtil.writeInt2((dstIndex += 4) - structStart, dst, cnOffsetOffset);
                System.arraycopy(cnBytes, 0, dst, dstIndex, cnBytes.length);
                dstIndex += cnBytes.length;
                dstIndex += this.pad8(dstIndex);
                SMBUtil.writeInt2(dstIndex - structStart, dst, dataOffsetOffset);
                int len = createContext.encode(dst, dstIndex);
                SMBUtil.writeInt4(len, dst, dataLengthOffset);
                int pad = this.pad8(dstIndex += len);
                totalCreateContextLength += len + pad;
                dstIndex += pad;
                lastStart = structStart;
                ++n2;
            }
        }
        SMBUtil.writeInt4(totalCreateContextLength, dst, createContextLengthOffset);
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return "[" + super.toString() + ",name=" + this.name + ",resolveDfs=" + this.resolveDfs + "]";
    }
}

