/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.lock;

import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.smb2.RequestWithFileId;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.lock.Smb2Lock;
import jcifs.internal.smb2.lock.Smb2LockResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2LockRequest
extends ServerMessageBlock2Request<Smb2LockResponse>
implements RequestWithFileId {
    private int lockSequenceNumber;
    private int lockSequenceIndex;
    private byte[] fileId;
    private final Smb2Lock[] locks;

    public Smb2LockRequest(Configuration config, byte[] fileId, Smb2Lock[] locks) {
        super(config, 10);
        this.fileId = fileId;
        this.locks = locks;
    }

    @Override
    protected Smb2LockResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2LockResponse> req) {
        return new Smb2LockResponse(tc.getConfig());
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    @Override
    public int size() {
        int size = 88;
        Smb2Lock[] smb2LockArray = this.locks;
        int n = this.locks.length;
        int n2 = 0;
        while (n2 < n) {
            Smb2Lock l = smb2LockArray[n2];
            size += l.size();
            ++n2;
        }
        return Smb2LockRequest.size8(size);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(48L, dst, dstIndex);
        SMBUtil.writeInt2(this.locks.length, dst, dstIndex + 2);
        SMBUtil.writeInt4((this.lockSequenceNumber & 0xF) << 28 | this.lockSequenceIndex & 0xFFFFFFF, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        dstIndex += 16;
        Smb2Lock[] smb2LockArray = this.locks;
        int n = this.locks.length;
        int n2 = 0;
        while (n2 < n) {
            Smb2Lock l = smb2LockArray[n2];
            dstIndex += l.encode(dst, dstIndex);
            ++n2;
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

