/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.nego;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb2.nego.NegotiateContextRequest;
import jcifs.internal.smb2.nego.NegotiateContextResponse;
import jcifs.internal.util.SMBUtil;

public class EncryptionNegotiateContext
implements NegotiateContextRequest,
NegotiateContextResponse {
    public static final int NEGO_CTX_ENC_TYPE = 2;
    public static final int CIPHER_AES128_CCM = 1;
    public static final int CIPHER_AES128_GCM = 2;
    private int[] ciphers;

    public EncryptionNegotiateContext(Configuration config, int[] ciphers) {
        this.ciphers = ciphers;
    }

    public EncryptionNegotiateContext() {
    }

    public int[] getCiphers() {
        return this.ciphers;
    }

    @Override
    public int getContextType() {
        return 2;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.ciphers != null ? this.ciphers.length : 0, dst, dstIndex);
        dstIndex += 2;
        if (this.ciphers != null) {
            int[] nArray = this.ciphers;
            int n = this.ciphers.length;
            int n2 = 0;
            while (n2 < n) {
                int cipher = nArray[n2];
                SMBUtil.writeInt2(cipher, dst, dstIndex);
                dstIndex += 2;
                ++n2;
            }
        }
        return dstIndex - start;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int nciphers = SMBUtil.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        this.ciphers = new int[nciphers];
        int i = 0;
        while (i < nciphers) {
            this.ciphers[i] = SMBUtil.readInt2(buffer, bufferIndex);
            bufferIndex += 2;
            ++i;
        }
        return bufferIndex - start;
    }

    @Override
    public int size() {
        return 4 + (this.ciphers != null ? 2 * this.ciphers.length : 0);
    }
}

