/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.nego;

import java.util.Date;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.DialectVersion;
import jcifs.internal.CommonServerMessageBlock;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.SmbNegotiationRequest;
import jcifs.internal.SmbNegotiationResponse;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.nego.EncryptionNegotiateContext;
import jcifs.internal.smb2.nego.NegotiateContextRequest;
import jcifs.internal.smb2.nego.NegotiateContextResponse;
import jcifs.internal.smb2.nego.PreauthIntegrityNegotiateContext;
import jcifs.internal.smb2.nego.Smb2NegotiateRequest;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import jcifs.util.transport.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2NegotiateResponse
extends ServerMessageBlock2Response
implements SmbNegotiationResponse {
    private static final Logger log = LoggerFactory.getLogger(Smb2NegotiateResponse.class);
    private int securityMode;
    private int dialectRevision;
    private byte[] serverGuid = new byte[16];
    private int capabilities;
    private int commonCapabilities;
    private int maxTransactSize;
    private int maxReadSize;
    private int maxWriteSize;
    private long systemTime;
    private long serverStartTime;
    private NegotiateContextResponse[] negotiateContexts;
    private byte[] securityBuffer;
    private DialectVersion selectedDialect;
    private boolean supportsEncryption;
    private int selectedCipher = -1;
    private int selectedPreauthHash = -1;

    public Smb2NegotiateResponse(Configuration cfg) {
        super(cfg);
    }

    @Override
    public int getInitialCredits() {
        return this.getCredit();
    }

    public int getDialectRevision() {
        return this.dialectRevision;
    }

    public byte[] getServerGuid() {
        return this.serverGuid;
    }

    @Override
    public DialectVersion getSelectedDialect() {
        return this.selectedDialect;
    }

    public int getSelectedCipher() {
        return this.selectedCipher;
    }

    public int getSelectedPreauthHash() {
        return this.selectedPreauthHash;
    }

    public final int getCapabilities() {
        return this.capabilities;
    }

    public final int getCommonCapabilities() {
        return this.commonCapabilities;
    }

    public byte[] getSecurityBlob() {
        return this.securityBuffer;
    }

    public int getMaxTransactSize() {
        return this.maxTransactSize;
    }

    @Override
    public int getTransactionBufferSize() {
        return this.getMaxTransactSize();
    }

    public NegotiateContextResponse[] getNegotiateContexts() {
        return this.negotiateContexts;
    }

    public long getServerStartTime() {
        return this.serverStartTime;
    }

    public int getSecurityMode() {
        return this.securityMode;
    }

    @Override
    public boolean haveCapabilitiy(int cap) {
        return (this.commonCapabilities & cap) == cap;
    }

    @Override
    public boolean isDFSSupported() {
        return !this.getConfig().isDfsDisabled() && this.haveCapabilitiy(1);
    }

    public boolean isEncryptionSupported() {
        return this.supportsEncryption;
    }

    @Override
    public boolean canReuse(CIFSContext tc, boolean forceSigning) {
        return this.getConfig().equals(tc.getConfig());
    }

    @Override
    public boolean isValid(CIFSContext tc, SmbNegotiationRequest req) {
        if (!this.isReceived() || this.getStatus() != 0) {
            return false;
        }
        if (req.isSigningEnforced() && !this.isSigningEnabled()) {
            log.error("Signing is enforced but server does not allow it");
            return false;
        }
        if (this.getDialectRevision() == 767) {
            log.error("Server returned ANY dialect");
            return false;
        }
        Smb2NegotiateRequest r = (Smb2NegotiateRequest)req;
        DialectVersion selected = null;
        DialectVersion[] dialectVersionArray = DialectVersion.values();
        int n = dialectVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DialectVersion dv = dialectVersionArray[n2];
            if (dv.isSMB2() && dv.getDialect() == this.getDialectRevision()) {
                selected = dv;
            }
            ++n2;
        }
        if (selected == null) {
            log.error("Server returned an unknown dialect");
            return false;
        }
        if (!selected.atLeast(this.getConfig().getMinimumVersion()) || !selected.atMost(this.getConfig().getMaximumVersion())) {
            log.error(String.format("Server selected an disallowed dialect version %s (min: %s max: %s)", new Object[]{selected, this.getConfig().getMinimumVersion(), this.getConfig().getMaximumVersion()}));
            return false;
        }
        this.selectedDialect = selected;
        this.commonCapabilities = r.getCapabilities() & this.capabilities;
        if ((this.commonCapabilities & 0x40) != 0) {
            this.supportsEncryption = tc.getConfig().isEncryptionEnabled();
        }
        if (this.selectedDialect.atLeast(DialectVersion.SMB311) && !this.checkNegotiateContexts(r, this.commonCapabilities)) {
            return false;
        }
        int maxBufferSize = tc.getConfig().getTransactionBufferSize();
        this.maxReadSize = Math.min(maxBufferSize - 80, Math.min(tc.getConfig().getReceiveBufferSize(), this.maxReadSize)) & 0xFFFFFFF8;
        this.maxWriteSize = Math.min(maxBufferSize - 112, Math.min(tc.getConfig().getSendBufferSize(), this.maxWriteSize)) & 0xFFFFFFF8;
        this.maxTransactSize = Math.min(maxBufferSize - 512, this.maxTransactSize) & 0xFFFFFFF8;
        return true;
    }

    private boolean checkNegotiateContexts(Smb2NegotiateRequest req, int caps) {
        if (this.negotiateContexts == null || this.negotiateContexts.length == 0) {
            log.error("Response lacks negotiate contexts");
            return false;
        }
        boolean foundPreauth = false;
        boolean foundEnc = false;
        NegotiateContextResponse[] negotiateContextResponseArray = this.negotiateContexts;
        int n = this.negotiateContexts.length;
        int n2 = 0;
        while (n2 < n) {
            NegotiateContextResponse ncr = negotiateContextResponseArray[n2];
            if (ncr != null) {
                if (!foundEnc && ncr.getContextType() == 2) {
                    foundEnc = true;
                    EncryptionNegotiateContext enc = (EncryptionNegotiateContext)ncr;
                    if (!Smb2NegotiateResponse.checkEncryptionContext(req, enc)) {
                        return false;
                    }
                    this.selectedCipher = enc.getCiphers()[0];
                    this.supportsEncryption = true;
                } else {
                    if (ncr.getContextType() == 2) {
                        log.error("Multiple encryption negotiate contexts");
                        return false;
                    }
                    if (!foundPreauth && ncr.getContextType() == 1) {
                        foundPreauth = true;
                        PreauthIntegrityNegotiateContext pi = (PreauthIntegrityNegotiateContext)ncr;
                        if (!Smb2NegotiateResponse.checkPreauthContext(req, pi)) {
                            return false;
                        }
                        this.selectedPreauthHash = pi.getHashAlgos()[0];
                    } else if (ncr.getContextType() == 1) {
                        log.error("Multiple preauth negotiate contexts");
                        return false;
                    }
                }
            }
            ++n2;
        }
        if (!foundPreauth) {
            log.error("Missing preauth negotiate context");
            return false;
        }
        if (!foundEnc && (caps & 0x40) != 0) {
            log.error("Missing encryption negotiate context");
            return false;
        }
        if (!foundEnc) {
            log.debug("No encryption support");
        }
        return true;
    }

    private static boolean checkPreauthContext(Smb2NegotiateRequest req, PreauthIntegrityNegotiateContext pc) {
        if (pc.getHashAlgos() == null || pc.getHashAlgos().length != 1) {
            log.error("Server returned no hash selection");
            return false;
        }
        PreauthIntegrityNegotiateContext rpc2 = null;
        NegotiateContextRequest[] negotiateContextRequestArray = req.getNegotiateContexts();
        int n = negotiateContextRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            NegotiateContextRequest rnc = negotiateContextRequestArray[n2];
            if (rnc instanceof PreauthIntegrityNegotiateContext) {
                rpc2 = (PreauthIntegrityNegotiateContext)rnc;
            }
            ++n2;
        }
        if (rpc2 == null) {
            return false;
        }
        boolean valid = false;
        int[] nArray = rpc2.getHashAlgos();
        int n3 = nArray.length;
        n = 0;
        while (n < n3) {
            int hash = nArray[n];
            if (hash == pc.getHashAlgos()[0]) {
                valid = true;
            }
            ++n;
        }
        if (!valid) {
            log.error("Server returned invalid hash selection");
            return false;
        }
        return true;
    }

    private static boolean checkEncryptionContext(Smb2NegotiateRequest req, EncryptionNegotiateContext ec) {
        if (ec.getCiphers() == null || ec.getCiphers().length != 1) {
            log.error("Server returned no cipher selection");
            return false;
        }
        EncryptionNegotiateContext rec = null;
        NegotiateContextRequest[] negotiateContextRequestArray = req.getNegotiateContexts();
        int n = negotiateContextRequestArray.length;
        int n2 = 0;
        while (n2 < n) {
            NegotiateContextRequest rnc = negotiateContextRequestArray[n2];
            if (rnc instanceof EncryptionNegotiateContext) {
                rec = (EncryptionNegotiateContext)rnc;
            }
            ++n2;
        }
        if (rec == null) {
            return false;
        }
        boolean valid = false;
        int[] nArray = rec.getCiphers();
        int n3 = nArray.length;
        n = 0;
        while (n < n3) {
            int cipher = nArray[n];
            if (cipher == ec.getCiphers()[0]) {
                valid = true;
            }
            ++n;
        }
        if (!valid) {
            log.error("Server returned invalid cipher selection");
            return false;
        }
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.maxReadSize;
    }

    @Override
    public int getSendBufferSize() {
        return this.maxWriteSize;
    }

    @Override
    public boolean isSigningEnabled() {
        return (this.securityMode & 1) != 0;
    }

    @Override
    public boolean isSigningRequired() {
        return (this.securityMode & 2) != 0;
    }

    @Override
    public boolean isSigningNegotiated() {
        return this.isSigningRequired();
    }

    @Override
    public void setupRequest(CommonServerMessageBlock request) {
    }

    @Override
    public void setupResponse(Response resp) {
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 65) {
            throw new SMBProtocolDecodingException("Structure size is not 65");
        }
        this.securityMode = SMBUtil.readInt2(buffer, bufferIndex + 2);
        this.dialectRevision = SMBUtil.readInt2(buffer, bufferIndex += 4);
        int negotiateContextCount = SMBUtil.readInt2(buffer, bufferIndex + 2);
        System.arraycopy(buffer, bufferIndex += 4, this.serverGuid, 0, 16);
        this.capabilities = SMBUtil.readInt4(buffer, bufferIndex += 16);
        this.maxTransactSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.maxReadSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.maxWriteSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.systemTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        this.serverStartTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        int securityBufferOffset = SMBUtil.readInt2(buffer, bufferIndex += 8);
        int securityBufferLength = SMBUtil.readInt2(buffer, bufferIndex + 2);
        int negotiateContextOffset = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        int hdrStart = this.getHeaderStart();
        if (hdrStart + securityBufferOffset + securityBufferLength < buffer.length) {
            this.securityBuffer = new byte[securityBufferLength];
            System.arraycopy(buffer, hdrStart + securityBufferOffset, this.securityBuffer, 0, securityBufferLength);
            bufferIndex += securityBufferLength;
        }
        int pad = (bufferIndex - hdrStart) % 8;
        bufferIndex += pad;
        if (this.dialectRevision == 785 && negotiateContextOffset != 0 && negotiateContextCount != 0) {
            int ncpos = this.getHeaderStart() + negotiateContextOffset;
            NegotiateContextResponse[] contexts = new NegotiateContextResponse[negotiateContextCount];
            int i = 0;
            while (i < negotiateContextCount) {
                int type = SMBUtil.readInt2(buffer, ncpos);
                int dataLen = SMBUtil.readInt2(buffer, ncpos + 2);
                ncpos += 4;
                ncpos += 4;
                NegotiateContextResponse ctx = Smb2NegotiateResponse.createContext(type);
                if (ctx != null) {
                    ctx.decode(buffer, ncpos, dataLen);
                    contexts[i] = ctx;
                }
                ncpos += dataLen;
                if (i != negotiateContextCount - 1) {
                    ncpos += this.pad8(ncpos);
                }
                ++i;
            }
            this.negotiateContexts = contexts;
            return Math.max(bufferIndex, ncpos) - start;
        }
        return bufferIndex - start;
    }

    protected static NegotiateContextResponse createContext(int type) {
        switch (type) {
            case 2: {
                return new EncryptionNegotiateContext();
            }
            case 1: {
                return new PreauthIntegrityNegotiateContext();
            }
        }
        return null;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("Smb2NegotiateResponse[" + super.toString() + ",dialectRevision=" + this.dialectRevision + ",securityMode=0x" + Hexdump.toHexString(this.securityMode, 1) + ",capabilities=0x" + Hexdump.toHexString(this.capabilities, 8) + ",serverTime=" + new Date(this.systemTime));
    }
}

