/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import jcifs.CIFSContext;
import jcifs.netbios.Name;
import jcifs.netbios.NbtAddress;
import jcifs.smb.SmbFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lmhosts {
    private static final Logger log = LoggerFactory.getLogger(Lmhosts.class);
    private final Map<Name, NbtAddress> table = new HashMap<Name, NbtAddress>();
    private long lastModified = 1L;
    private int alt;

    public synchronized NbtAddress getByName(String host, CIFSContext tc) {
        return this.getByName(new Name(tc.getConfig(), host, 32, null), tc);
    }

    synchronized NbtAddress getByName(Name name, CIFSContext tc) {
        NbtAddress result;
        block13: {
            result = null;
            try {
                if (tc.getConfig().getLmHostsFileName() == null) break block13;
                File f = new File(tc.getConfig().getLmHostsFileName());
                long lm = f.lastModified();
                if (lm > this.lastModified) {
                    if (log.isDebugEnabled()) {
                        log.debug("Reading " + tc.getConfig().getLmHostsFileName());
                    }
                    this.lastModified = lm;
                    this.table.clear();
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try (FileReader r = new FileReader(f);){
                        this.populate(r, tc);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                result = this.table.get(name);
            }
            catch (IOException fnfe) {
                log.error("Could not read lmhosts " + tc.getConfig().getLmHostsFileName(), (Throwable)fnfe);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    void populate(Reader r, CIFSContext tc) throws IOException {
        br = new BufferedReader(r);
        while ((line = br.readLine()) != null) {
            block19: {
                block20: {
                    if ((line = line.toUpperCase().trim()).length() == 0) continue;
                    if (line.charAt(0) != '#') break block19;
                    if (!line.startsWith("#INCLUDE ")) break block20;
                    line = line.substring(line.indexOf(92));
                    url = "smb:" + line.replace('\\', '/');
                    var6_6 = null;
                    var7_9 = null;
                    try {
                        block18: {
                            rdr = new InputStreamReader(new SmbFileInputStream(url, tc));
                            try {
                                if (this.alt <= 0) ** GOTO lbl26
                                try {
                                    this.populate(rdr, tc);
                                    ** GOTO lbl-1000
                                }
                                catch (IOException ioe) {
                                    Lmhosts.log.error("Failed to read include " + url, (Throwable)ioe);
                                    if (rdr == null) continue;
                                    rdr.close();
                                    continue;
                                }
                            }
                            catch (Throwable var6_7) {
                                if (rdr != null) {
                                    rdr.close();
                                }
                                throw var6_7;
                            }
                            {
                                while (!(line = line.toUpperCase().trim()).startsWith("#END_ALTERNATE")) lbl-1000:
                                // 2 sources

                                {
                                    if ((line = br.readLine()) != null) continue;
                                    break block18;
                                }
                                break block18;
lbl26:
                                // 1 sources

                                this.populate(rdr, tc);
                            }
                        }
                        if (rdr == null) continue;
                        rdr.close();
                        continue;
                    }
                    catch (Throwable var7_10) {
                        if (var6_6 == null) {
                            var6_6 = var7_10;
                        } else if (var6_6 != var7_10) {
                            var6_6.addSuppressed(var7_10);
                        }
                        throw var6_6;
                    }
                }
                if (line.startsWith("#BEGIN_ALTERNATE") || !line.startsWith("#END_ALTERNATE") || this.alt <= 0) continue;
                throw new IOException("no lmhosts alternate includes loaded");
            }
            if (!Character.isDigit(line.charAt(0))) continue;
            data = line.toCharArray();
            c = 46;
            i = 0;
            ip = 0;
            while (i < data.length && c == 46) {
                b = 0;
                while (i < data.length && (c = data[i]) >= 48 && c <= 57) {
                    b = b * 10 + c - 48;
                    ++i;
                }
                ip = (ip << 8) + b;
                ++i;
            }
            while (i < data.length && Character.isWhitespace(data[i])) {
                ++i;
            }
            j = i;
            while (j < data.length && !Character.isWhitespace(data[j])) {
                ++j;
            }
            name = new Name(tc.getConfig(), line.substring(i, j), 32, null);
            addr = new NbtAddress(name, ip, false, 0, false, false, true, true, NbtAddress.UNKNOWN_MAC_ADDRESS);
            if (Lmhosts.log.isDebugEnabled()) {
                Lmhosts.log.debug("Adding " + name + " with addr " + addr);
            }
            this.table.put(name, addr);
        }
    }
}

