/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import jcifs.Configuration;
import jcifs.NetbiosName;
import jcifs.util.Hexdump;
import jcifs.util.Strings;

public class Name
implements NetbiosName {
    private static final int TYPE_OFFSET = 31;
    private static final int SCOPE_OFFSET = 33;
    public String name;
    public String scope;
    public int hexCode;
    int srcHashCode;
    private Configuration config;

    Name(Configuration cfg) {
        this.config = cfg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public int getNameType() {
        return this.hexCode;
    }

    public Name(Configuration cfg, String name, int hexCode, String scope) {
        this.config = cfg;
        if (name.length() > 15) {
            name = name.substring(0, 15);
        }
        this.name = name.toUpperCase();
        this.hexCode = hexCode;
        this.scope = scope != null && scope.length() > 0 ? scope : cfg.getNetbiosScope();
        this.srcHashCode = 0;
    }

    public Name(Configuration cfg, NetbiosName name) {
        this.config = cfg;
        this.name = name.getName();
        this.hexCode = name.getNameType();
        this.scope = name.getScope();
        if (name instanceof Name) {
            this.srcHashCode = ((Name)name).srcHashCode;
        }
    }

    public boolean isUnknown() {
        return "0.0.0.0".equals(this.name) && this.hexCode == 0 && this.scope == null;
    }

    int writeWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = 32;
        byte[] tmp = Strings.getOEMBytes(this.name, this.config);
        int i = 0;
        while (i < tmp.length) {
            dst[dstIndex + (2 * i + 1)] = (byte)(((tmp[i] & 0xF0) >> 4) + 65);
            dst[dstIndex + (2 * i + 2)] = (byte)((tmp[i] & 0xF) + 65);
            ++i;
        }
        while (i < 15) {
            dst[dstIndex + (2 * i + 1)] = 67;
            dst[dstIndex + (2 * i + 2)] = 65;
            ++i;
        }
        dst[dstIndex + 31] = (byte)(((this.hexCode & 0xF0) >> 4) + 65);
        dst[dstIndex + 31 + 1] = (byte)((this.hexCode & 0xF) + 65);
        return 33 + this.writeScopeWireFormat(dst, dstIndex + 33);
    }

    int readWireFormat(byte[] src, int srcIndex) {
        byte[] tmp = new byte[33];
        int length = 15;
        int i = 0;
        while (i < 15) {
            tmp[i] = (byte)((src[srcIndex + (2 * i + 1)] & 0xFF) - 65 << 4);
            int n = i;
            tmp[n] = (byte)(tmp[n] | (byte)((src[srcIndex + (2 * i + 2)] & 0xFF) - 65 & 0xF));
            if (tmp[i] != 32) {
                length = i + 1;
            }
            ++i;
        }
        this.name = Strings.fromOEMBytes(tmp, 0, length, this.config);
        this.hexCode = (src[srcIndex + 31] & 0xFF) - 65 << 4;
        this.hexCode |= (src[srcIndex + 31 + 1] & 0xFF) - 65 & 0xF;
        return 33 + this.readScopeWireFormat(src, srcIndex + 33);
    }

    int writeScopeWireFormat(byte[] dst, int dstIndex) {
        if (this.scope == null) {
            dst[dstIndex] = 0;
            return 1;
        }
        dst[dstIndex++] = 46;
        System.arraycopy(Strings.getOEMBytes(this.scope, this.config), 0, dst, dstIndex, this.scope.length());
        dstIndex += this.scope.length();
        dst[dstIndex++] = 0;
        int i = dstIndex - 2;
        int e = i - this.scope.length();
        int c = 0;
        do {
            if (dst[i] == 46) {
                dst[i] = (byte)c;
                c = 0;
                continue;
            }
            ++c;
        } while (i-- > e);
        return this.scope.length() + 2;
    }

    int readScopeWireFormat(byte[] src, int srcIndex) {
        int n;
        int start = srcIndex;
        if ((n = src[srcIndex++] & 0xFF) == 0) {
            this.scope = null;
            return 1;
        }
        StringBuffer sb = new StringBuffer(Strings.fromOEMBytes(src, srcIndex, n, this.config));
        srcIndex += n;
        while ((n = src[srcIndex++] & 0xFF) != 0) {
            sb.append('.').append(Strings.fromOEMBytes(src, srcIndex, n, this.config));
            srcIndex += n;
        }
        this.scope = sb.toString();
        return srcIndex - start;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result += 65599 * this.hexCode;
        result += 65599 * this.srcHashCode;
        if (this.scope != null && this.scope.length() != 0) {
            result += this.scope.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Name)) {
            return false;
        }
        Name n = (Name)obj;
        if (this.scope == null && n.scope == null) {
            return this.name.equals(n.name) && this.hexCode == n.hexCode;
        }
        return this.name.equals(n.name) && this.hexCode == n.hexCode && this.scope.equals(n.scope);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String n = this.name;
        if (n == null) {
            n = "null";
        } else if (n.charAt(0) == '\u0001') {
            char[] c = n.toCharArray();
            c[0] = 46;
            c[1] = 46;
            c[14] = 46;
            n = new String(c);
        }
        sb.append(n).append("<").append(Hexdump.toHexString(this.hexCode, 2)).append(">");
        if (this.scope != null) {
            sb.append(".").append(this.scope);
        }
        return sb.toString();
    }
}

