/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.NameServiceClient;
import jcifs.NetbiosAddress;
import jcifs.ResolverType;
import jcifs.RuntimeCIFSException;
import jcifs.netbios.Lmhosts;
import jcifs.netbios.Name;
import jcifs.netbios.NameQueryRequest;
import jcifs.netbios.NameQueryResponse;
import jcifs.netbios.NameServicePacket;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NodeStatusRequest;
import jcifs.netbios.NodeStatusResponse;
import jcifs.netbios.UniAddress;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceClientImpl
implements Runnable,
NameServiceClient {
    private static final int NAME_SERVICE_UDP_PORT = 137;
    static final byte[] UNKNOWN_MAC_ADDRESS = new byte[6];
    private static final Logger log = LoggerFactory.getLogger(NameServiceClientImpl.class);
    private final Object LOCK = new Object();
    private int nbnsIndex = 0;
    private final Map<Name, CacheEntry> addressCache = new HashMap<Name, CacheEntry>();
    private final Set<Name> inFlightLookups = new HashSet<Name>();
    private int lport;
    private int closeTimeout;
    private byte[] snd_buf;
    private byte[] rcv_buf;
    private DatagramSocket socket;
    private DatagramPacket in;
    private DatagramPacket out;
    private Map<Integer, NameServicePacket> responseTable = new HashMap<Integer, NameServicePacket>();
    private Thread thread;
    private int nextNameTrnId = 0;
    private List<ResolverType> resolveOrder = new ArrayList<ResolverType>();
    private InetAddress laddr;
    private InetAddress baddr;
    private CIFSContext transportContext;
    private NbtAddress localhostAddress;
    private Lmhosts lmhosts = new Lmhosts();
    private Name unknownName;
    private NbtAddress unknownAddress;

    public NameServiceClientImpl(CIFSContext tc) {
        this(tc.getConfig().getNetbiosLocalPort(), tc.getConfig().getNetbiosLocalAddress(), tc);
    }

    NameServiceClientImpl(int lport, InetAddress laddr, CIFSContext tc) {
        this.lport = lport;
        this.laddr = laddr;
        this.transportContext = tc;
        this.baddr = tc.getConfig().getBroadcastAddress();
        this.snd_buf = new byte[tc.getConfig().getNetbiosSndBufSize()];
        this.rcv_buf = new byte[tc.getConfig().getNetbiosRcvBufSize()];
        this.out = new DatagramPacket(this.snd_buf, tc.getConfig().getNetbiosSndBufSize(), this.baddr, 137);
        this.in = new DatagramPacket(this.rcv_buf, tc.getConfig().getNetbiosRcvBufSize());
        this.resolveOrder = tc.getConfig().getResolveOrder();
        this.initCache(tc);
    }

    private void initCache(CIFSContext tc) {
        String localHostname;
        this.unknownName = new Name(tc.getConfig(), "0.0.0.0", 0, null);
        this.unknownAddress = new NbtAddress(this.unknownName, 0, false, 0);
        this.addressCache.put(this.unknownName, new CacheEntry(this.unknownName, this.unknownAddress, -1L));
        InetAddress localInetAddress = tc.getConfig().getNetbiosLocalAddress();
        if (localInetAddress == null) {
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                try {
                    localInetAddress = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException ignored) {
                    throw new RuntimeCIFSException(ignored);
                }
            }
        }
        if ((localHostname = tc.getConfig().getNetbiosHostname()) == null || localHostname.length() == 0) {
            byte[] addr = localInetAddress.getAddress();
            localHostname = "JCIFS" + (addr[2] & 0xFF) + "_" + (addr[3] & 0xFF) + "_" + Hexdump.toHexString((int)(Math.random() * 255.0), 2);
        }
        Name localName = new Name(tc.getConfig(), localHostname, 0, tc.getConfig().getNetbiosScope());
        this.localhostAddress = new NbtAddress(localName, localInetAddress.hashCode(), false, 0, false, false, true, false, UNKNOWN_MAC_ADDRESS);
        this.cacheAddress(localName, this.localhostAddress, -1L);
    }

    NbtAddress doNameQuery(Name name, InetAddress svr) throws UnknownHostException {
        NbtAddress addr;
        block8: {
            if (name.hexCode == 29 && svr == null) {
                svr = this.baddr;
            }
            name.srcHashCode = svr != null ? svr.hashCode() : 0;
            addr = this.getCachedAddress(name);
            if (addr == null && (addr = (NbtAddress)this.checkLookupTable(name)) == null) {
                try {
                    try {
                        addr = this.getByName(name, svr);
                    }
                    catch (UnknownHostException unknownHostException) {
                        addr = this.unknownAddress;
                        this.cacheAddress(name, addr);
                        this.updateLookupTable(name);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.cacheAddress(name, addr);
                    this.updateLookupTable(name);
                    throw throwable;
                }
                this.cacheAddress(name, addr);
                this.updateLookupTable(name);
            }
        }
        if (addr == this.unknownAddress) {
            throw new UnknownHostException(name.toString());
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object checkLookupTable(Name name) {
        Set<Name> set = this.inFlightLookups;
        synchronized (set) {
            if (!this.inFlightLookups.contains(name)) {
                this.inFlightLookups.add(name);
                return null;
            }
            while (this.inFlightLookups.contains(name)) {
                try {
                    this.inFlightLookups.wait();
                }
                catch (InterruptedException e) {
                    log.trace("Interrupted", (Throwable)e);
                }
            }
        }
        NbtAddress obj = this.getCachedAddress(name);
        if (obj != null) return obj;
        set = this.inFlightLookups;
        synchronized (set) {
            this.inFlightLookups.add(name);
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLookupTable(Name name) {
        Set<Name> set = this.inFlightLookups;
        synchronized (set) {
            this.inFlightLookups.remove(name);
            this.inFlightLookups.notifyAll();
        }
    }

    void cacheAddress(Name hostName, NbtAddress addr) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return;
        }
        long expiration = -1L;
        if (this.transportContext.getConfig().getNetbiosCachePolicy() != -1) {
            expiration = System.currentTimeMillis() + (long)(this.transportContext.getConfig().getNetbiosCachePolicy() * 1000);
        }
        this.cacheAddress(hostName, addr, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheAddress(Name hostName, NbtAddress addr, long expiration) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return;
        }
        Map<Name, CacheEntry> map = this.addressCache;
        synchronized (map) {
            CacheEntry entry = this.addressCache.get(hostName);
            if (entry == null) {
                entry = new CacheEntry(hostName, addr, expiration);
                this.addressCache.put(hostName, entry);
            } else {
                entry.address = addr;
                entry.expiration = expiration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheAddressArray(NbtAddress[] addrs) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return;
        }
        long expiration = -1L;
        if (this.transportContext.getConfig().getNetbiosCachePolicy() != -1) {
            expiration = System.currentTimeMillis() + (long)(this.transportContext.getConfig().getNetbiosCachePolicy() * 1000);
        }
        Map<Name, CacheEntry> map = this.addressCache;
        synchronized (map) {
            int i = 0;
            while (i < addrs.length) {
                CacheEntry entry = this.addressCache.get(addrs[i].hostName);
                if (entry == null) {
                    entry = new CacheEntry(addrs[i].hostName, addrs[i], expiration);
                    this.addressCache.put(addrs[i].hostName, entry);
                } else {
                    entry.address = addrs[i];
                    entry.expiration = expiration;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NbtAddress getCachedAddress(Name hostName) {
        if (this.transportContext.getConfig().getNetbiosCachePolicy() == 0) {
            return null;
        }
        Map<Name, CacheEntry> map = this.addressCache;
        synchronized (map) {
            CacheEntry entry = this.addressCache.get(hostName);
            if (entry != null && entry.expiration < System.currentTimeMillis() && entry.expiration >= 0L) {
                entry = null;
            }
            return entry != null ? entry.address : null;
        }
    }

    int getNextNameTrnId() {
        if ((++this.nextNameTrnId & 0xFFFF) == 0) {
            this.nextNameTrnId = 1;
        }
        return this.nextNameTrnId;
    }

    void ensureOpen(int timeout) throws IOException {
        this.closeTimeout = 0;
        if (this.transportContext.getConfig().getNetbiosSoTimeout() != 0) {
            this.closeTimeout = Math.max(this.transportContext.getConfig().getNetbiosSoTimeout(), timeout);
        }
        if (this.socket == null) {
            this.socket = new DatagramSocket(this.lport, this.laddr);
            this.thread = new Thread((Runnable)this, "JCIFS-NameServiceClient");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryClose() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.thread = null;
            this.responseTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            block10: while (true) {
                try {
                    while (this.thread == Thread.currentThread()) {
                        this.in.setLength(this.transportContext.getConfig().getNetbiosRcvBufSize());
                        this.socket.setSoTimeout(this.closeTimeout);
                        this.socket.receive(this.in);
                        log.trace("NetBIOS: new data read from socket");
                        int nameTrnId = NameServicePacket.readNameTrnId(this.rcv_buf, 0);
                        NameServicePacket response = this.responseTable.get(new Integer(nameTrnId));
                        if (response == null || response.received) continue;
                        NameServicePacket nameServicePacket = response;
                        synchronized (nameServicePacket) {
                            response.readWireFormat(this.rcv_buf, 0);
                            response.received = true;
                            if (log.isTraceEnabled()) {
                                log.trace(response.toString());
                                log.trace(Hexdump.toHexString(this.rcv_buf, 0, this.in.getLength()));
                            }
                            response.notify();
                            continue block10;
                        }
                    }
                    break block13;
                }
                catch (SocketTimeoutException ste) {
                    log.trace("Socket timeout", (Throwable)ste);
                    this.tryClose();
                    break block13;
                }
                catch (Exception ex) {
                    log.warn("Uncaught exception in NameServiceClient", (Throwable)ex);
                    this.tryClose();
                    break block13;
                }
            }
            finally {
                this.tryClose();
            }
        }
    }

    /*
     * Exception decompiling
     */
    void send(NameServicePacket request, NameServicePacket response, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    NbtAddress[] getAllByName(Name name, InetAddress addr) throws UnknownHostException {
        int n;
        Configuration config = this.transportContext.getConfig();
        NameQueryRequest request = new NameQueryRequest(config, name);
        NameQueryResponse response = new NameQueryResponse(config);
        request.addr = addr != null ? addr : this.getWINSAddress();
        boolean bl = request.isBroadcast = request.addr == null || this.isBroadcastAddress(request.addr);
        if (request.isBroadcast) {
            if (request.addr == null) {
                request.addr = this.baddr;
            }
            n = config.getNetbiosRetryCount();
        } else {
            n = 1;
        }
        do {
            try {
                this.send(request, response, config.getNetbiosRetryTimeout());
            }
            catch (InterruptedIOException ioe) {
                if (log.isTraceEnabled()) {
                    log.trace("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                }
                throw new UnknownHostException(name.name);
            }
            catch (IOException ioe) {
                log.info("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                throw new UnknownHostException(name.name);
            }
            if (!response.received || response.resultCode != 0) continue;
            return response.addrEntry;
        } while (--n > 0 && request.isBroadcast);
        throw new UnknownHostException(name.name);
    }

    NbtAddress getByName(Name name, InetAddress addr) throws UnknownHostException {
        NameQueryRequest request = new NameQueryRequest(this.transportContext.getConfig(), name);
        NameQueryResponse response = new NameQueryResponse(this.transportContext.getConfig());
        if (addr != null) {
            request.addr = addr;
            request.isBroadcast = this.isBroadcastAddress(addr);
            int n = this.transportContext.getConfig().getNetbiosRetryCount();
            do {
                try {
                    this.send(request, response, this.transportContext.getConfig().getNetbiosRetryTimeout());
                }
                catch (InterruptedIOException ioe) {
                    if (log.isTraceEnabled()) {
                        log.trace("Timeout waiting for response " + name.name, (Throwable)ioe);
                    }
                    throw new UnknownHostException(name.name);
                }
                catch (IOException ioe) {
                    log.info("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                    throw new UnknownHostException(name.name);
                }
                if (!response.received || response.resultCode != 0) continue;
                int last = response.addrEntry.length - 1;
                response.addrEntry[last].hostName.srcHashCode = addr.hashCode();
                return response.addrEntry[last];
            } while (--n > 0 && request.isBroadcast);
            throw new UnknownHostException(name.name);
        }
        block12: for (ResolverType resolverType : this.resolveOrder) {
            try {
                switch (resolverType) {
                    case RESOLVER_LMHOSTS: {
                        NbtAddress ans = this.lmhosts.getByName(name, this.transportContext);
                        if (ans == null) continue block12;
                        ans.hostName.srcHashCode = 0;
                        return ans;
                    }
                    case RESOLVER_WINS: 
                    case RESOLVER_BCAST: {
                        if (resolverType == ResolverType.RESOLVER_WINS && name.name != "\u0001\u0002__MSBROWSE__\u0002" && name.hexCode != 29) {
                            request.addr = this.getWINSAddress();
                            request.isBroadcast = false;
                        } else {
                            request.addr = this.baddr;
                            request.isBroadcast = true;
                        }
                        int n = this.transportContext.getConfig().getNetbiosRetryCount();
                        while (n-- > 0) {
                            try {
                                this.send(request, response, this.transportContext.getConfig().getNetbiosRetryTimeout());
                            }
                            catch (IOException ioe) {
                                log.info("Failed to send nameservice request for " + name.name, (Throwable)ioe);
                                throw new UnknownHostException(name.name);
                            }
                            if (response.received && response.resultCode == 0) {
                                response.addrEntry[0].hostName.srcHashCode = request.addr.hashCode();
                                return response.addrEntry[0];
                            }
                            if (resolverType == ResolverType.RESOLVER_WINS) continue block12;
                        }
                        continue block12;
                    }
                }
            }
            catch (IOException ioe) {
                log.debug("Failed to lookup name", (Throwable)ioe);
            }
        }
        throw new UnknownHostException(name.name);
    }

    public NbtAddress[] getNodeStatus(NetbiosAddress addr) throws UnknownHostException {
        NodeStatusResponse response = new NodeStatusResponse(this.transportContext.getConfig(), addr.unwrap(NbtAddress.class));
        NodeStatusRequest request = new NodeStatusRequest(this.transportContext.getConfig(), new Name(this.transportContext.getConfig(), "*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", 0, null));
        request.addr = addr.toInetAddress();
        int n = this.transportContext.getConfig().getNetbiosRetryCount();
        while (n-- > 0) {
            try {
                this.send(request, response, this.transportContext.getConfig().getNetbiosRetryTimeout());
            }
            catch (IOException ioe) {
                log.info("Failed to send node status request for " + addr, (Throwable)ioe);
                throw new UnknownHostException(addr.toString());
            }
            if (!response.received || response.resultCode != 0) continue;
            int srcHashCode = request.addr.hashCode();
            int i = 0;
            while (i < response.addressArray.length) {
                response.addressArray[i].hostName.srcHashCode = srcHashCode;
                ++i;
            }
            return response.addressArray;
        }
        throw new UnknownHostException(addr.getHostName());
    }

    @Override
    public NbtAddress getNbtByName(String host) throws UnknownHostException {
        return this.getNbtByName(host, 0, null);
    }

    @Override
    public NbtAddress getNbtByName(String host, int type, String scope) throws UnknownHostException {
        return this.getNbtByName(host, type, scope, null);
    }

    @Override
    public NbtAddress getNbtByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return this.getLocalHost();
        }
        Name name = new Name(this.transportContext.getConfig(), host, type, scope);
        if (!Character.isDigit(host.charAt(0))) {
            return this.doNameQuery(name, svr);
        }
        int IP = 0;
        int hitDots = 0;
        char[] data = host.toCharArray();
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return this.doNameQuery(name, svr);
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return this.doNameQuery(name, svr);
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return this.doNameQuery(name, svr);
            }
            IP = (IP << 8) + b;
            ++hitDots;
            ++i;
        }
        if (hitDots != 4 || host.endsWith(".")) {
            return this.doNameQuery(name, svr);
        }
        return new NbtAddress(this.getUnknownName(), IP, false, 0);
    }

    public NbtAddress[] getNbtAllByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        return this.getAllByName(new Name(this.transportContext.getConfig(), host, type, scope), svr);
    }

    public NbtAddress[] getNbtAllByAddress(String host) throws UnknownHostException {
        return this.getNbtAllByAddress(this.getNbtByName(host, 0, null));
    }

    public NbtAddress[] getNbtAllByAddress(String host, int type, String scope) throws UnknownHostException {
        return this.getNbtAllByAddress(this.getNbtByName(host, type, scope));
    }

    public NbtAddress[] getNbtAllByAddress(NetbiosAddress addr) throws UnknownHostException {
        try {
            NbtAddress[] addrs = this.getNodeStatus(addr);
            this.cacheAddressArray(addrs);
            return addrs;
        }
        catch (UnknownHostException unknownHostException) {
            throw new UnknownHostException("no name with type 0x" + Hexdump.toHexString(addr.getNameType(), 2) + (addr.getName().getScope() == null || addr.getName().getScope().isEmpty() ? " with no scope" : " with scope " + addr.getName().getScope()) + " for host " + addr.getHostAddress());
        }
    }

    protected InetAddress getWINSAddress() {
        return this.transportContext.getConfig().getWinsServers().length == 0 ? null : this.transportContext.getConfig().getWinsServers()[this.nbnsIndex];
    }

    protected boolean isWINS(InetAddress svr) {
        int i = 0;
        while (svr != null && i < this.transportContext.getConfig().getWinsServers().length) {
            if (svr.hashCode() == this.transportContext.getConfig().getWinsServers()[i].hashCode()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isBroadcastAddress(InetAddress svr) {
        return svr.equals(this.baddr) || svr.getAddress()[3] == -1;
    }

    protected InetAddress switchWINS() {
        this.nbnsIndex = this.nbnsIndex + 1 < this.transportContext.getConfig().getWinsServers().length ? this.nbnsIndex + 1 : 0;
        return this.transportContext.getConfig().getWinsServers().length == 0 ? null : this.transportContext.getConfig().getWinsServers()[this.nbnsIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetbiosAddress[] lookupServerOrWorkgroup(String name, InetAddress svr) throws UnknownHostException {
        Sem sem = new Sem(2);
        int type = this.isWINS(svr) ? 27 : 29;
        QueryThread q1x = new QueryThread(sem, name, type, null, svr, this.transportContext);
        QueryThread q20 = new QueryThread(sem, name, 32, null, svr, this.transportContext);
        q1x.setDaemon(true);
        q20.setDaemon(true);
        try {
            Sem sem2 = sem;
            synchronized (sem2) {
                q1x.start();
                q20.start();
                while (sem.count > 0 && q1x.getAnswer() == null && q20.getAnswer() == null) {
                    sem.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new UnknownHostException(name);
        }
        NameServiceClientImpl.waitForQueryThreads(q1x, q20);
        if (q1x.getAnswer() != null) {
            return q1x.getAnswer();
        }
        if (q20.getAnswer() != null) {
            return q20.getAnswer();
        }
        throw q1x.getException();
    }

    private static void waitForQueryThreads(QueryThread q1x, QueryThread q20) {
        NameServiceClientImpl.interruptThreadSafely(q1x);
        NameServiceClientImpl.joinThread(q1x);
        NameServiceClientImpl.interruptThreadSafely(q20);
        NameServiceClientImpl.joinThread(q20);
    }

    private static void interruptThreadSafely(QueryThread thread) {
        try {
            thread.interrupt();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private static void joinThread(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean isAllDigits(String hostname) {
        int i = 0;
        while (i < hostname.length()) {
            if (!Character.isDigit(hostname.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public UniAddress getByName(String hostname) throws UnknownHostException {
        return this.getByName(hostname, false);
    }

    @Override
    public UniAddress getByName(String hostname, boolean possibleNTDomainOrWorkgroup) throws UnknownHostException {
        return this.getAllByName(hostname, possibleNTDomainOrWorkgroup)[0];
    }

    public UniAddress[] getAllByName(String hostname, boolean possibleNTDomainOrWorkgroup) throws UnknownHostException {
        if (hostname == null || hostname.length() == 0) {
            throw new UnknownHostException();
        }
        if (UniAddress.isDotQuadIP(hostname)) {
            return new UniAddress[]{new UniAddress(this.getNbtByName(hostname))};
        }
        if (log.isTraceEnabled()) {
            log.trace("Resolver order is " + this.transportContext.getConfig().getResolveOrder());
        }
        block8: for (ResolverType resolver : this.transportContext.getConfig().getResolveOrder()) {
            Object[] addr = null;
            try {
                switch (resolver) {
                    case RESOLVER_LMHOSTS: {
                        NbtAddress lmaddr = this.getLmhosts().getByName(hostname, this.transportContext);
                        if (lmaddr == null) continue block8;
                        addr = new NetbiosAddress[]{lmaddr};
                        break;
                    }
                    case RESOLVER_WINS: {
                        if (hostname.equals("\u0001\u0002__MSBROWSE__\u0002") || hostname.length() > 15) continue block8;
                        if (possibleNTDomainOrWorkgroup) {
                            addr = this.lookupServerOrWorkgroup(hostname, this.getWINSAddress());
                            break;
                        }
                        addr = this.getNbtAllByName(hostname, 32, null, this.getWINSAddress());
                        break;
                    }
                    case RESOLVER_BCAST: {
                        if (hostname.length() > 15) continue block8;
                        if (possibleNTDomainOrWorkgroup) {
                            addr = this.lookupServerOrWorkgroup(hostname, this.transportContext.getConfig().getBroadcastAddress());
                            break;
                        }
                        addr = this.getNbtAllByName(hostname, 32, null, this.transportContext.getConfig().getBroadcastAddress());
                        break;
                    }
                    case RESOLVER_DNS: {
                        if (NameServiceClientImpl.isAllDigits(hostname)) {
                            throw new UnknownHostException(hostname);
                        }
                        Object[] addrs = NameServiceClientImpl.wrapInetAddresses(InetAddress.getAllByName(hostname));
                        if (log.isDebugEnabled()) {
                            log.debug("Resolved '{}' to {} using DNS", (Object)hostname, (Object)Arrays.toString(addrs));
                        }
                        return addrs;
                    }
                    default: {
                        throw new UnknownHostException(hostname);
                    }
                }
                if (addr == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Resolved '{}' to addrs {} via {}", new Object[]{hostname, Arrays.toString(addr), resolver});
                }
                return NameServiceClientImpl.wrapNetbiosAddresses((NetbiosAddress[])addr);
            }
            catch (IOException ioe) {
                log.trace("Resolving {} via {} failed:", (Object)hostname, (Object)resolver);
                log.trace("Exception is", (Throwable)ioe);
            }
        }
        throw new UnknownHostException(hostname);
    }

    private static UniAddress[] wrapInetAddresses(InetAddress[] iaddrs) {
        UniAddress[] addrs = new UniAddress[iaddrs.length];
        int ii = 0;
        while (ii < iaddrs.length) {
            addrs[ii] = new UniAddress(iaddrs[ii]);
            ++ii;
        }
        return addrs;
    }

    private static UniAddress[] wrapNetbiosAddresses(NetbiosAddress[] addr) {
        UniAddress[] addrs = new UniAddress[addr.length];
        int i = 0;
        while (i < addr.length) {
            addrs[i] = new UniAddress(addr[i]);
            ++i;
        }
        return addrs;
    }

    @Override
    public NbtAddress getLocalHost() {
        return this.localhostAddress;
    }

    @Override
    public Name getLocalName() {
        if (this.localhostAddress != null) {
            return this.localhostAddress.hostName;
        }
        return null;
    }

    public Lmhosts getLmhosts() {
        return this.lmhosts;
    }

    @Override
    public Name getUnknownName() {
        return this.unknownName;
    }

    static final class CacheEntry {
        Name hostName;
        NbtAddress address;
        long expiration;

        CacheEntry(Name hostName, NbtAddress address, long expiration) {
            this.hostName = hostName;
            this.address = address;
            this.expiration = expiration;
        }
    }

    static class QueryThread
    extends Thread {
        private Sem sem;
        private String host;
        private String scope;
        private int type;
        private NetbiosAddress[] ans = null;
        private InetAddress svr;
        private UnknownHostException uhe;
        private CIFSContext tc;

        QueryThread(Sem sem, String host, int type, String scope, InetAddress svr, CIFSContext tc) {
            super("JCIFS-QueryThread: " + host);
            this.sem = sem;
            this.host = host;
            this.type = type;
            this.scope = scope;
            this.svr = svr;
            this.tc = tc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                try {
                    this.ans = this.tc.getNameServiceClient().getNbtAllByName(this.host, this.type, this.scope, this.svr);
                }
                catch (UnknownHostException ex) {
                    this.uhe = ex;
                    Sem sem = this.sem;
                    synchronized (sem) {
                        --this.sem.count;
                        this.sem.notify();
                        break block18;
                    }
                }
                catch (Exception ex) {
                    Sem sem;
                    try {
                        this.uhe = new UnknownHostException(ex.getMessage());
                        sem = this.sem;
                    }
                    catch (Throwable throwable) {
                        Sem sem2 = this.sem;
                        synchronized (sem2) {
                            --this.sem.count;
                            this.sem.notify();
                        }
                        throw throwable;
                    }
                    synchronized (sem) {
                        --this.sem.count;
                        this.sem.notify();
                        break block18;
                    }
                }
                Sem sem = this.sem;
                synchronized (sem) {
                    --this.sem.count;
                    this.sem.notify();
                }
            }
        }

        public NetbiosAddress[] getAnswer() {
            return this.ans;
        }

        public UnknownHostException getException() {
            return this.uhe;
        }
    }

    static class Sem {
        int count;

        Sem(int count) {
            this.count = count;
        }
    }
}

