/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import jcifs.CIFSException;

public class NbtException
extends CIFSException {
    private static final long serialVersionUID = 492638554095148960L;
    public static final int SUCCESS = 0;
    public static final int ERR_NAM_SRVC = 1;
    public static final int ERR_SSN_SRVC = 2;
    public static final int FMT_ERR = 1;
    public static final int SRV_ERR = 2;
    public static final int IMP_ERR = 4;
    public static final int RFS_ERR = 5;
    public static final int ACT_ERR = 6;
    public static final int CFT_ERR = 7;
    public static final int CONNECTION_REFUSED = -1;
    public static final int NOT_LISTENING_CALLED = 128;
    public static final int NOT_LISTENING_CALLING = 129;
    public static final int CALLED_NOT_PRESENT = 130;
    public static final int NO_RESOURCES = 131;
    public static final int UNSPECIFIED = 143;
    public int errorClass;
    public int errorCode;

    public static String getErrorString(int errorClass, int errorCode) {
        String result = "";
        block0 : switch (errorClass) {
            case 0: {
                result = String.valueOf(result) + "SUCCESS";
                break;
            }
            case 1: {
                result = String.valueOf(result) + "ERR_NAM_SRVC/";
                switch (errorCode) {
                    case 1: {
                        result = String.valueOf(result) + "FMT_ERR: Format Error";
                    }
                }
                result = String.valueOf(result) + "Unknown error code: " + errorCode;
                break;
            }
            case 2: {
                result = String.valueOf(result) + "ERR_SSN_SRVC/";
                switch (errorCode) {
                    case -1: {
                        result = String.valueOf(result) + "Connection refused";
                        break block0;
                    }
                    case 128: {
                        result = String.valueOf(result) + "Not listening on called name";
                        break block0;
                    }
                    case 129: {
                        result = String.valueOf(result) + "Not listening for calling name";
                        break block0;
                    }
                    case 130: {
                        result = String.valueOf(result) + "Called name not present";
                        break block0;
                    }
                    case 131: {
                        result = String.valueOf(result) + "Called name present, but insufficient resources";
                        break block0;
                    }
                    case 143: {
                        result = String.valueOf(result) + "Unspecified error";
                        break block0;
                    }
                }
                result = String.valueOf(result) + "Unknown error code: " + errorCode;
                break;
            }
            default: {
                result = String.valueOf(result) + "unknown error class: " + errorClass;
            }
        }
        return result;
    }

    public NbtException(int errorClass, int errorCode) {
        super(NbtException.getErrorString(errorClass, errorCode));
        this.errorClass = errorClass;
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        return new String("errorClass=" + this.errorClass + ",errorCode=" + this.errorCode + ",errorString=" + NbtException.getErrorString(this.errorClass, this.errorCode));
    }
}

