/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Map;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.pac.PACDecodingException;
import jcifs.pac.PacCredentialType;
import jcifs.pac.PacDataInputStream;
import jcifs.pac.PacLogonInfo;
import jcifs.pac.PacMac;
import jcifs.pac.PacSignature;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac {
    private static final Logger log = LoggerFactory.getLogger(Pac.class);
    private PacLogonInfo logonInfo;
    private PacCredentialType credentialType;
    private PacSignature serverSignature;
    private PacSignature kdcSignature;

    public Pac(byte[] data, Map<Integer, KerberosKey> keys) throws PACDecodingException {
        byte[] checksumData = (byte[])data.clone();
        try {
            PacDataInputStream pacStream = new PacDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
            if (data.length <= 8) {
                throw new PACDecodingException("Empty PAC");
            }
            int bufferCount = pacStream.readInt();
            int version = pacStream.readInt();
            if (version != 0) {
                throw new PACDecodingException("Unrecognized PAC version " + version);
            }
            int bufferIndex = 0;
            while (bufferIndex < bufferCount) {
                int bufferType = pacStream.readInt();
                int bufferSize = pacStream.readInt();
                long bufferOffset = pacStream.readLong();
                if (bufferOffset % 8L != 0L) {
                    throw new PACDecodingException("Unaligned buffer " + bufferType);
                }
                byte[] bufferData = new byte[bufferSize];
                System.arraycopy(data, (int)bufferOffset, bufferData, 0, bufferSize);
                switch (bufferType) {
                    case 1: {
                        if (this.logonInfo != null) break;
                        this.logonInfo = new PacLogonInfo(bufferData);
                        break;
                    }
                    case 2: {
                        this.credentialType = new PacCredentialType(bufferData);
                        break;
                    }
                    case 6: {
                        if (this.serverSignature != null) break;
                        this.serverSignature = new PacSignature(bufferData);
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Server signature is type %d @ %d len %d", this.serverSignature.getType(), bufferOffset, bufferSize));
                        }
                        int i = 0;
                        while (i < this.serverSignature.getChecksum().length) {
                            checksumData[(int)bufferOffset + 4 + i] = 0;
                            ++i;
                        }
                        break;
                    }
                    case 7: {
                        if (this.kdcSignature != null) break;
                        this.kdcSignature = new PacSignature(bufferData);
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("KDC signature is type %d @ %d len %d", this.kdcSignature.getType(), bufferOffset, bufferSize));
                        }
                        int i = 0;
                        while (i < this.kdcSignature.getChecksum().length) {
                            checksumData[(int)bufferOffset + 4 + i] = 0;
                            ++i;
                        }
                        break;
                    }
                    default: {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Found unhandled PAC buffer " + bufferType);
                    }
                }
                ++bufferIndex;
            }
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed PAC", e);
        }
        if (this.serverSignature == null || this.kdcSignature == null || this.logonInfo == null) {
            throw new PACDecodingException("Missing required buffers");
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Checksum data %s type %d signature %s", Hexdump.toHexString(checksumData), this.serverSignature.getType(), Hexdump.toHexString(this.serverSignature.getChecksum())));
        }
        byte[] checksum = PacMac.calculateMac(this.serverSignature.getType(), keys, checksumData);
        if (!MessageDigest.isEqual(this.serverSignature.getChecksum(), checksum)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("PAC signature validation failed, have: %s expected: %s type: %d len: %d", Hexdump.toHexString(checksum), Hexdump.toHexString(this.serverSignature.getChecksum()), this.serverSignature.getType(), data.length));
            }
            if (log.isTraceEnabled()) {
                log.trace(String.format("Checksum data %s", Hexdump.toHexString(checksumData)));
            }
            throw new PACDecodingException("Invalid PAC signature");
        }
    }

    public PacLogonInfo getLogonInfo() {
        return this.logonInfo;
    }

    public PacCredentialType getCredentialType() {
        return this.credentialType;
    }

    public PacSignature getServerSignature() {
        return this.serverSignature;
    }

    public PacSignature getKdcSignature() {
        return this.kdcSignature;
    }
}

