/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import jcifs.pac.PACDecodingException;
import jcifs.pac.PacUnicodeString;
import jcifs.smb.SID;

public class PacDataInputStream {
    private DataInputStream dis;
    private int size;

    public PacDataInputStream(InputStream in) throws IOException {
        this.dis = new DataInputStream(in);
        this.size = in.available();
    }

    public void align(int mask) throws IOException {
        int position = this.size - this.dis.available();
        int shift = position & mask - 1;
        if (mask != 0 && shift != 0) {
            this.dis.skip(mask - shift);
        }
    }

    public int available() throws IOException {
        return this.dis.available();
    }

    public void readFully(byte[] b) throws IOException {
        this.dis.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dis.readFully(b, off, len);
    }

    public char readChar() throws IOException {
        this.align(2);
        return this.dis.readChar();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public short readShort() throws IOException {
        this.align(2);
        return Short.reverseBytes(this.dis.readShort());
    }

    public int readInt() throws IOException {
        this.align(4);
        return Integer.reverseBytes(this.dis.readInt());
    }

    public long readLong() throws IOException {
        this.align(8);
        return Long.reverseBytes(this.dis.readLong());
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public Date readFiletime() throws IOException {
        Date date = null;
        long last = this.readUnsignedInt();
        long first = this.readUnsignedInt();
        if (first != Integer.MAX_VALUE && last != 0xFFFFFFFFL) {
            BigInteger lastBigInt = BigInteger.valueOf(last);
            BigInteger firstBigInt = BigInteger.valueOf(first);
            BigInteger completeBigInt = lastBigInt.add(firstBigInt.shiftLeft(32));
            completeBigInt = completeBigInt.divide(BigInteger.valueOf(10000L));
            completeBigInt = completeBigInt.add(BigInteger.valueOf(-11644473600000L));
            date = new Date(completeBigInt.longValue());
        }
        return date;
    }

    public PacUnicodeString readUnicodeString() throws IOException, PACDecodingException {
        short length = this.readShort();
        short maxLength = this.readShort();
        int pointer = this.readInt();
        if (maxLength < length) {
            throw new PACDecodingException("Malformed string in PAC");
        }
        return new PacUnicodeString(length, maxLength, pointer);
    }

    public String readString() throws IOException, PACDecodingException {
        int totalChars = this.readInt();
        int unusedChars = this.readInt();
        int usedChars = this.readInt();
        if (unusedChars > totalChars || usedChars > totalChars - unusedChars) {
            throw new PACDecodingException("Malformed string in PAC");
        }
        this.dis.skip(unusedChars * 2);
        char[] chars = new char[usedChars];
        int l = 0;
        while (l < usedChars) {
            chars[l] = (char)this.readShort();
            ++l;
        }
        return new String(chars);
    }

    public SID readId() throws IOException, PACDecodingException {
        byte[] bytes = new byte[4];
        this.readFully(bytes);
        byte[] sidBytes = new byte[8 + bytes.length];
        sidBytes[0] = 1;
        sidBytes[1] = (byte)(bytes.length / 4);
        byte[] byArray = new byte[6];
        byArray[5] = 5;
        System.arraycopy(byArray, 0, sidBytes, 2, 6);
        System.arraycopy(bytes, 0, sidBytes, 8, bytes.length);
        return new SID(sidBytes, 0);
    }

    public SID readSid() throws IOException, PACDecodingException {
        int sidSize = this.readInt();
        byte[] bytes = new byte[8 + sidSize * 4];
        this.readFully(bytes);
        return new SID(bytes, 0);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }
}

