/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac.kerberos;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.pac.PACDecodingException;
import jcifs.pac.kerberos.KerberosPacAuthData;
import jcifs.pac.kerberos.KerberosRelevantAuthData;

public abstract class KerberosAuthData {
    public static List<KerberosAuthData> parse(int authType, byte[] token, Map<Integer, KerberosKey> keys) throws PACDecodingException {
        List<KerberosAuthData> authorizations = new ArrayList<KerberosAuthData>();
        switch (authType) {
            case 1: {
                authorizations = new KerberosRelevantAuthData(token, keys).getAuthorizations();
                break;
            }
            case 128: {
                authorizations.add(new KerberosPacAuthData(token, keys));
            }
        }
        return authorizations;
    }
}

