/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac.kerberos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.pac.ASN1Util;
import jcifs.pac.PACDecodingException;
import jcifs.pac.kerberos.KerberosAuthData;
import jcifs.util.Encdec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DEROctetString;

public class KerberosEncData {
    private String userRealm;
    private String userPrincipalName;
    private ArrayList<InetAddress> userAddresses;
    private List<KerberosAuthData> userAuthorizations;

    public KerberosEncData(byte[] token, Map<Integer, KerberosKey> keys) throws PACDecodingException {
        ASN1Sequence sequence;
        ASN1TaggedObject derToken;
        ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(token));
        try {
            derToken = ASN1Util.as(ASN1TaggedObject.class, stream);
            if (derToken.getTagClass() != 64) {
                throw new PACDecodingException("Malformed kerberos ticket");
            }
            stream.close();
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos ticket", e);
        }
        try {
            sequence = ASN1Util.as(ASN1Sequence.class, derToken.getBaseObject());
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos ticket", e);
        }
        Enumeration fields = sequence.getObjects();
        block19: while (fields.hasMoreElements()) {
            ASN1TaggedObject tagged = ASN1Util.as(ASN1TaggedObject.class, fields);
            switch (tagged.getTagNo()) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    DERGeneralString derRealm = ASN1Util.as(DERGeneralString.class, tagged);
                    this.userRealm = derRealm.getString();
                    break;
                }
                case 3: {
                    ASN1Sequence principalSequence = ASN1Util.as(ASN1Sequence.class, tagged);
                    ASN1Sequence nameSequence = ASN1Util.as(ASN1Sequence.class, ASN1Util.as(ASN1TaggedObject.class, principalSequence, 1));
                    StringBuilder nameBuilder = new StringBuilder();
                    Enumeration parts = nameSequence.getObjects();
                    while (parts.hasMoreElements()) {
                        Object part = parts.nextElement();
                        DERGeneralString stringPart = ASN1Util.as(DERGeneralString.class, part);
                        nameBuilder.append(stringPart.getString());
                        if (!parts.hasMoreElements()) continue;
                        nameBuilder.append('/');
                    }
                    this.userPrincipalName = nameBuilder.toString();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    ASN1Sequence adressesSequence = ASN1Util.as(ASN1Sequence.class, tagged);
                    Enumeration adresses = adressesSequence.getObjects();
                    while (adresses.hasMoreElements()) {
                        ASN1Sequence addressSequence = ASN1Util.as(ASN1Sequence.class, adresses);
                        ASN1Integer addressType = ASN1Util.as(ASN1Integer.class, addressSequence, 0);
                        DEROctetString addressOctets = ASN1Util.as(DEROctetString.class, addressSequence, 1);
                        this.userAddresses = new ArrayList();
                        if (addressType.getValue().intValue() != 2) continue;
                        InetAddress userAddress = null;
                        try {
                            userAddress = InetAddress.getByAddress(addressOctets.getOctets());
                        }
                        catch (UnknownHostException unknownHostException) {}
                        this.userAddresses.add(userAddress);
                    }
                    continue block19;
                }
                case 10: {
                    ASN1Sequence authSequence = ASN1Util.as(ASN1Sequence.class, tagged);
                    this.userAuthorizations = new ArrayList<KerberosAuthData>();
                    Enumeration authElements = authSequence.getObjects();
                    while (authElements.hasMoreElements()) {
                        ASN1Sequence authElement = ASN1Util.as(ASN1Sequence.class, authElements);
                        ASN1Integer authType = ASN1Util.as(ASN1Integer.class, ASN1Util.as(ASN1TaggedObject.class, authElement, 0));
                        DEROctetString authData = ASN1Util.as(DEROctetString.class, ASN1Util.as(ASN1TaggedObject.class, authElement, 1));
                        this.userAuthorizations.addAll(KerberosAuthData.parse(authType.getValue().intValue(), authData.getOctets(), keys));
                    }
                    continue block19;
                }
                default: {
                    throw new PACDecodingException("Unknown field " + tagged.getTagNo());
                }
            }
        }
    }

    public static byte[] decrypt(byte[] data, Key key, int type) throws GeneralSecurityException {
        Cipher cipher = null;
        byte[] decrypt = null;
        switch (type) {
            case 3: {
                decrypt = KerberosEncData.decryptDES(data, key, cipher);
                break;
            }
            case 23: {
                decrypt = KerberosEncData.decryptRC4(data, key);
                break;
            }
            default: {
                throw new GeneralSecurityException("Unsupported encryption type " + type);
            }
        }
        return decrypt;
    }

    private static byte[] decryptRC4(byte[] data, Key key) throws GeneralSecurityException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] code = new byte[4];
        Encdec.enc_uint32le(2, code, 0);
        byte[] codeHmac = KerberosEncData.getHmac(code, key.getEncoded());
        byte[] dataChecksum = new byte[16];
        System.arraycopy(data, 0, dataChecksum, 0, 16);
        byte[] dataHmac = KerberosEncData.getHmac(dataChecksum, codeHmac);
        SecretKeySpec dataKey = new SecretKeySpec(dataHmac, "ARCFOUR");
        Cipher cipher = Cipher.getInstance("ARCFOUR");
        cipher.init(2, dataKey);
        int plainDataLength = data.length - 16;
        byte[] plainData = cipher.doFinal(data, 16, plainDataLength);
        byte[] plainDataChecksum = KerberosEncData.getHmac(plainData, codeHmac);
        if (plainDataChecksum.length >= 16) {
            int i = 0;
            while (i < 16) {
                if (plainDataChecksum[i] != data[i]) {
                    throw new GeneralSecurityException("Checksum failed while decrypting.");
                }
                ++i;
            }
        }
        int decryptLength = plainData.length - 8;
        byte[] decrypt = new byte[decryptLength];
        System.arraycopy(plainData, 8, decrypt, 0, decryptLength);
        return decrypt;
    }

    private static byte[] decryptDES(byte[] data, Key key, Cipher cipher) throws GeneralSecurityException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec skSpec;
        try {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GeneralSecurityException("Checksum failed while decrypting.");
        }
        byte[] ivec = new byte[8];
        IvParameterSpec params = new IvParameterSpec(ivec);
        SecretKeySpec sk = skSpec = new SecretKeySpec(key.getEncoded(), "DES");
        cipher.init(2, (Key)sk, params);
        byte[] result = cipher.doFinal(data);
        byte[] decrypt = new byte[result.length];
        System.arraycopy(result, 0, decrypt, 0, result.length);
        int tempSize = decrypt.length - 24;
        byte[] output = new byte[tempSize];
        System.arraycopy(decrypt, 24, output, 0, tempSize);
        decrypt = output;
        return decrypt;
    }

    private static byte[] getHmac(byte[] data, byte[] key) throws GeneralSecurityException {
        SecretKeySpec macKey = new SecretKeySpec((byte[])key.clone(), "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(macKey);
        return mac.doFinal(data);
    }

    public String getUserRealm() {
        return this.userRealm;
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public ArrayList<InetAddress> getUserAddresses() {
        return this.userAddresses;
    }

    public List<KerberosAuthData> getUserAuthorizations() {
        return this.userAuthorizations;
    }
}

